
#VERSION = "3.0 For PB 5.61 Linux"

#DQUOTE$ = Chr('"')

Define.s Functions, Init
Functions = PeekS(?l_codestart, ?l_codeend - ?l_codestart, #PB_Ascii)


#AnzKeywords = 60 ; +5 mit PB4
Global Dim keywords.s(#AnzKeywords)

Structure LINE
  s.s
  nr.l
EndStructure
NewList Lines.Line()

Structure BLOCKS
  StartNr.l
EndStructure
NewList blocks.BLOCKS()


Restore l_keywords
For z = 1 To #AnzKeywords
  Read.s keywords(z)
Next

Procedure.s MyTrim(s.s)
  Protected *p.CHARACTER, *n.CHARACTER
  
  *p = @s
  While (*p\c = ' ' Or *p\c = 9) And *p\c
    *p + SizeOf(CHARACTER)
  Wend
  ; *p zeigt auf Start des Textes
  
  ; suche Ende
  *n = *p
  While *n\c <> 0
    *n + SizeOf(CHARACTER)
  Wend
  
  *n - SizeOf(CHARACTER)
  While (*n\c = ' ' Or *n\c = 9) And *n > *p
    *n - SizeOf(CHARACTER)
  Wend
  
  ProcedureReturn PeekS(*p, (*n + SizeOf(CHARACTER) - *p)/SizeOf(CHARACTER))
EndProcedure

Procedure.l InKeywords(s.s)
  Protected z.l, len.l
  
  s = LCase(s)
  For z = 1 To #AnzKeywords
    len = Len(keywords(z))
    If Left(s, len) = keywords(z)
      ProcedureReturn #True
    EndIf
  Next
  
  ProcedureReturn #False
EndProcedure

Procedure.s MyPath()
  ProcedureReturn ProgramFilename()
EndProcedure

Procedure.s CurDir()
  ProcedureReturn GetCurrentDirectory()
EndProcedure

Procedure.s ComTrim(line.s)
  Protected *p.CHARACTER, s.s, InString1.l, InString2.l
  
  *p = @line
  While *p\c <> 0
    
    If InString2 = #False And *p\c = '"'
      If InString1 = #False
        InString1 = #True
      Else
        InString1 = #False
      EndIf
    ElseIf InString1 = #False And *p\c = Asc("'")
      If InString2 = #False
        InString2 = #True
      Else
        InString2 = #False
      EndIf
    EndIf
    
    If InString1 = #False And InString2 = #False And *p\c = ';'
      ProcedureReturn s
    EndIf
    
    s + Chr(*p\c)
    
    *p + SizeOf(CHARACTER)
  Wend
  
  ProcedureReturn s.s
EndProcedure

Procedure.l IsMultiLine(line.s)
  Protected *p.CHARACTER, InString1.l, InString2.l
  
  *p = @line
  While *p\c <> 0
    
    If InString2 = #False And *p\c = '"'
      If InString1 = #False
        InString1 = #True
      Else
        InString1 = #False
      EndIf
    ElseIf InString1 = #False And *p\c = Asc("'")
      If InString2 = #False
        InString2 = #True
      Else
        InString2 = #False
      EndIf
    EndIf
    
    If InString1 = #False And InString2 = #False And *p\c = ':'
      ProcedureReturn #True
    EndIf
    
    *p + SizeOf(CHARACTER)
  Wend
  
  ProcedureReturn #False
EndProcedure





;- Load Preferences
OpenPreferences(MyPath() + "analyzer.ini")
pAnalyze = ReadPreferenceLong("analyze", #True)
pInlineProc = ReadPreferenceLong("inlineproc", #True)
pShowAllLines = ReadPreferenceLong("showallanalyzedlines", #True)
ClosePreferences()


File.s = ProgramParameter()
If File = ""
  If pAnalyze
    pAnalyze = #False
    MessageRequester("Analyzer - " + #VERSION, "Analyzer turned off.")
  Else
    pAnalyze = #True
    MessageRequester("Analyzer - " + #VERSION, "Analyzer turned on.")
  EndIf
EndIf





If File <> "" And pAnalyze And ReadFile(0, File)
  FileType = ReadStringFormat(0)
  
  
  nr.l = 0
  While Eof(0) = 0
    nr + 1
    
    s.s = MyTrim(ReadString(0, FileType))
    If s <> "" 
      If PeekB(@s) <> ';' 
        AddElement(Lines())
        Lines()\s   = MyTrim(ComTrim(s))
        Lines()\nr  = nr
      ElseIf LCase(s) = "; pause" Or LCase(s) = "; continue" Or Left(LCase(s), 7) = "; block" Or LCase(s) = "; endblock" 
        AddElement(Lines())
        Lines()\s   = s
        Lines()\nr  = nr
      EndIf
    EndIf
  Wend
  CloseFile(0)
  
  
  
  Functions = ReplaceString(Functions, "__xxx__", Str(nr))
  Functions = ReplaceString(Functions, "__BUILD__", #VERSION)
  
  If pShowAllLines
    Functions = RemoveString(Functions, "__xxxtimes")
    Functions = RemoveString(Functions, "__xxxtimee")
  Else
    Functions = ReplaceString(Functions, "__xxxtimes", "If __an_lines(z)\time > 0")
    Functions = ReplaceString(Functions, "__xxxtimee", "EndIf" + #CRLF$)
  EndIf
  
  
  Pause.l = #False
  Comment.l = #False
  ForEach Lines()
    s.s = LCase(Lines()\s)
    
    If IsMultiLine(s) = #False
      If s = "end"
        InsertElement(Lines())
        Lines()\s = "__an_end()"
        NextElement(Lines())
        
      ElseIf Pause = #False And Left(s, 9) = "structure"
        Pause = #True
        
      ElseIf Pause = #False And Left(s, 11) = "enumeration"
        Pause = #True
        
      ElseIf Pause = #False And Left(s, 9) = "interface"
        Pause = #True
        
      ElseIf Pause = #False And Left(s, 11) = "datasection"
        Pause = #True
        
      ElseIf Pause = #False And Left(s, 5) = "macro"
        Pause = #True
        
      ElseIf Pause = #False And Left(s, 6) = "import"
        Pause = #True
        
      ElseIf Comment = #False And Left(s, 7) = "; pause"
        Comment = #True
        
      ElseIf Pause = #True
        If s <> "endstructureunion" And Left(s, 12) = "endstructure"
          Pause = #False
        ElseIf Left(s, 14) = "endenumeration"
          Pause = #False
        ElseIf Left(s, 12) = "endinterface"
          Pause = #False
        ElseIf Left(s, 14) = "enddatasection"
          Pause = #False
        ElseIf Left(s, 8) = "endmacro"
          Pause = #False
        ElseIf Left(s, 9) = "endimport"
          Pause = #False
        EndIf
        
        ;       ElseIf Pause = #True And Left(s, 3) = "end"
        ;         If s <> "endstructureunion"
        ;           Pause = #False
        ;         EndIf
        
      ElseIf Comment = #True And Left(s, 10) = "; continue"
        Comment = #False
        
      ElseIf Pause = #False And Comment = #False And InKeywords(Lines()\s) = #False
        nr.l = Lines()\nr
        
        If Left(s, 7) = "; block"
          Init + "__an_lines(" + Str(nr) + ")\s = " + #DQUOTE$ + "BLOCK:  " + Right(Lines()\s, Len(s) - 7) + #DQUOTE$ + #CRLF$
          
          AddElement(blocks())
          blocks()\StartNr = nr
          
          InsertElement(Lines())
          If pInlineProc
            Lines()\s = "__an_times(" + Str(nr) + ") = ElapsedMilliseconds()"
          Else
            Lines()\s = "__an_timer(" + Str(nr) + ")"
          EndIf
          NextElement(Lines())
          
        ElseIf s = "; endblock"
          If ListSize(blocks()) > 0
            AddElement(Lines())
            If pInlineProc
              Lines()\s = "__an_lines(" + Str(blocks()\StartNr) + ")\time + ElapsedMilliseconds() - __an_times(" + Str(blocks()\StartNr) + ")" + #CRLF$ + "    __an_lines(" + Str(blocks()\StartNr) + ")\called + 1" + #CRLF$
            Else
              Lines()\s = "__an_timer(" + Str(blocks()\StartNr) + ")"
            EndIf
            DeleteElement(blocks())
          EndIf
          
        Else
          Init + "__an_lines(" + Str(nr) + ")\s = " + #DQUOTE$ + RemoveString(Lines()\s, #DQUOTE$) + #DQUOTE$ + #CRLF$
          
          If pInlineProc
            InsertElement(Lines())
            Lines()\s = "__an_times(" + Str(nr) + ") = ElapsedMilliseconds()"
            NextElement(Lines())
            AddElement(Lines())
            Lines()\s = "__an_lines(" + Str(nr) + ")\time + ElapsedMilliseconds() - __an_times(" + Str(nr) + ")" + #CRLF$ + "__an_lines(" + Str(nr) + ")\called + 1" + #CRLF$
          Else
            InsertElement(Lines())
            Lines()\s = "__an_timer(" + Str(nr) + ")"
            NextElement(Lines())
            AddElement(Lines())
            Lines()\s = "__an_timer(" + Str(nr) + ")"
          EndIf
        EndIf
      EndIf
      
    Else
      ; Multiline = #true
      k.l = FindString(s, "end", 1)
      If k
        If k = 1 Or ((Asc(Mid(s, k - 1, 1)) < 'a' Or Asc(Mid(s, k - 1, 1)) > 'z') And Mid(s, k - 1, 1) <> "_")
          If Len(s) - k < 3 Or ((Asc(Mid(s, k + 3, 1)) < 'a' Or Asc(Mid(s, k + 3, 1)) > 'z') And Mid(s, k + 3, 1) <> "_")
            n.s = "Found a line which includes ':' and 'end'."+#CRLF$
            n.s + "Analyzer doesn't support the ':' operator!"+#CRLF$
            n.s + "If this is a line which quits the program,"+#CRLF$
            n.s + "Analyzer won't be able to end properly, which"+#CRLF$
            n.s + "can cause several problems!"+#CRLF$
            n.s + Lines()\s+#CRLF$
            n.s + "LineNb: " + Str(Lines()\nr)
            MessageRequester("Analyzer - Warning", n)
          EndIf
        EndIf
      EndIf
    EndIf
  Next
  Init + #CRLF$ + #CRLF$
  
  Functions = ReplaceString(Functions, "__FILLININITS__", Init)
  
  FirstElement(Lines())
  InsertElement(Lines())
  Lines()\s = Functions + #CRLF$ + "__an_init()" + #CRLF$
  
  LastElement(Lines())
  AddElement(Lines())
  Lines()\s = "__an_end()" + #CRLF$
  
  
  If CreateFile(0, File+"_analyzed.pb")
    WriteStringFormat(0, FileType)
    ForEach Lines()
      WriteStringN(0, Lines()\s, FileType)
    Next
    CloseFile(0)
  Else
    MessageRequester("Analyzer - " + #VERSION, "Error creating file!")
  EndIf
EndIf



;- Save Preferences
CreatePreferences(MyPath() + "analyzer.ini")
WritePreferenceLong("analyze", pAnalyze)
WritePreferenceLong("inlineproc", pInlineProc)
WritePreferenceLong("showallanalyzedlines", pShowAllLines)
ClosePreferences()




DataSection
l_keywords:
Data.s  "break"
Data.s  "calldebugger"
Data.s  "case"
Data.s  "compilercase"
Data.s  "compilerdefault"
Data.s  "compilerelse"
Data.s  "compilerendif"
Data.s  "compilerendselect"
Data.s  "compilerif"
Data.s  "compilerselect"
Data.s  "continue"
Data.s  "data"
Data.s  "datasection"
Data.s  "debug"
Data.s  "debuglevel"
Data.s  "declare"
Data.s  "declarecdll"
Data.s  "declaredll"
Data.s  "default"
Data.s  "define."
Data.s  "disabledebugger"
Data.s  "else"
Data.s  "elseif"
Data.s  "enabledebugger"
Data.s  "endif"
Data.s  "endprocedure"
Data.s  "endselect"
Data.s  "enumeration"
Data.s  "fakereturn"
Data.s  "for"
Data.s  "foreach"
Data.s  "forever"
Data.s  "global "
Data.s  "if"
Data.s  "includebinary"
Data.s  "includefile"
Data.s  "includepath"
Data.s  "interface"
Data.s  "next"
Data.s  "procedure"
Data.s  "procedurecdll"
Data.s  "proceduredll"
Data.s  "procedurereturn"
Data.s  "protected "
Data.s  "repeat"
Data.s  "restore"
Data.s  "return"
Data.s  "select"
Data.s  "shared"
Data.s  "static"
Data.s  "until"
Data.s  "wend"
Data.s  "while"
Data.s  "xincludefile"
Data.s  "#"
  
  ; PB 4.0
Data.s "compilererror"
Data.s "prototype"
Data.s "procedurec"
Data.s "enableexplicit"
Data.s "disableexplicit"
EndDataSection

DataSection
l_codestart:
IncludeBinary "Functions.pb"
l_codeend:
EndDataSection


; IDE Options = PureBasic v4.00 - Beta 1 (Windows - x86)
; CursorPosition = 276
; FirstLine = 164
; Folding = A+
; EnableXP
; Executable = ..\analyzer.exe
; IDE Options = PureBasic 5.61 (Linux - x64)
; CursorPosition = 274
; FirstLine = 227
; Folding = y-
; Executable = analyzer
; SubSystem = gtk2
; CompileSourceDirectory
; EnableUnicode