﻿
XIncludeFile "app.h.pbi"

XIncludeFile "thread.h.pbi"
XIncludeFile "drawing.h.pbi"
XIncludeFile "object.h.pbi"

XIncludeFile "assert.pbi"

Declare OpenGui()
Declare createScene()


Procedure init() : End
;   Shared objects(), *objectsStart, *objectsEnd, *playerObject, cam
  Shared semaphoreDraw, semaphoreMain
;   Shared semaphoreDraw, semaphoreMain, thread
;   Shared MouseX, MouseY, ww, wh
;   Shared zoom, zoomInitStart
;   Shared init, initTime, initTimer
;   Shared canvas, canvasImage
;   Shared cam
  
  app\font = LoadFont(#PB_Any, "Arial", 10)

  OpenGui()
  
  app\canvasImage = CreateImage(#PB_Any, GadgetWidth(app\canvas), GadgetHeight(app\canvas));, 32)
  
  createScene()
  
  sortObjects()
  
  LastElement(app\objects())
  app\objectsStart = app\objects()
  app\objectsEnd   = app\objects()
  
  If #threaded
    semaphoreDraw = CreateSemaphore()
    semaphoreMain = CreateSemaphore(1)
    app\thread    = CreateThread( @ draw(), @ app)
  EndIf
  
  app\MouseX = app\ww/2
  app\MouseY = app\wh/2
  
  ; player position relative to cam (if not visible try reduced zoom)
  app\cam\playerX = 0
  app\cam\playerY = 150
  app\cam\playerZ = -20
  
  Assert(app\player\ship)
  setPos(app\player\ship, 
         (app\cam\x + app\cam\playerX), 
         (app\cam\y + app\cam\playerY), 
         (app\cam\z + app\cam\playerZ), 
         #previous_reset)
  updateTravelledSpace(app\player\ship)
  
  app\init = #True
  app\zoom = app\zoomInitStart
  app\initTime.f = 1000
  app\initTimer.f = ElapsedMilliseconds() + app\initTime
EndProcedure

Procedure OpenGui()
;   Shared ww, wh, win, style, canvas
  app\style | #PB_Window_ScreenCentered
  app\style | #PB_Window_SystemMenu
  app\style | #PB_Window_MinimizeGadget
  
  app\win = OpenWindow(#PB_Any,  50, 100,  app\ww, app\wh, "", app\style)
  AddKeyboardShortcut(app\win, #PB_Shortcut_Escape, 10)
  
  Define canvasFlags
  canvasFlags | #PB_Canvas_Keyboard
  app\canvas = CanvasGadget(#PB_Any, 0, 0, app\ww, app\wh, canvasFlags)
  SetGadgetAttribute(app\canvas, #PB_Canvas_Cursor, #PB_Cursor_Invisible)
  ;SetGadgetAttribute(app\canvas, #PB_Canvas_Cursor, #PB_Cursor_Cross)
  SetActiveGadget(app\canvas)
  
EndProcedure

Procedure createScene()
;   Shared *playerObject, cam
;   Shared debugSpawnPoints, debugColliders
  Protected *object.sObject
  Define color
  Define properties
  
  If 0
    ;{ testing nodes behind and before object position
    color = $aaffffff
    properties = #property_isShootable
    createBoxCollidable( (0),    (200),   (0),    100,   100,  100,   color, color, properties)
    createBoxCollidable( (0),      (0),   (0),    100,   100,  100,   color, color, properties)
    createBoxCollidable( (0),   (-200),   (0),    100,   100,  100,   color, color, properties)
    ;createBoxCollidable( (0),      (0),   (0),   1000,  1000, 1000,   color, color, properties)
    ;createBoxCollidable( (0),   (1000),   (0),    100, 20000,  100,   color, color, properties)
    ;}
  EndIf
  
  If 0
    ;{ some random boxes
    Define maxn = 500
    Define n
    Define alpha = $66000000
    Define colorLines, colorFaces
    properties = #property_isShootable
    For n=0 To maxn-1
      If n % 3 = 0
        colorLines = RGBA(55+Random(200), 55+Random(200), 55+Random(200), 55+Random(200))
        colorFaces = RGBA(55+Random(200), 55+Random(200), 55+Random(200), 55+Random(200))
        createBoxCollidable( (0),   (200*n),   (0),   500, 500, 500,  colorLines, colorFaces, properties)
        Define m
        For m=1 To 10
          colorLines = RGBA(55+Random(200), 55+Random(200), 55+Random(200), 55+Random(200))
          colorFaces = RGBA(55+Random(200), 55+Random(200), 55+Random(200), 55+Random(200))
          createBoxCollidable( (Random(4000)-2000),   (200*n),   (Random(4000)-2000),   100, 100, 100,  colorLines, colorFaces, properties)
        Next
      EndIf
    Next
    ;}
  EndIf
  
  If 0
    ;{ patchwork ground, one object per tile
    Define x, y
    #w = 50
    Define w2 = #w/2
    Define alpha = $66000000
    Define colorLines, colorFaces
    properties = #property_isShootable
    For y=10000 To -1000 Step -#w
      For x=-100 To 100 Step #w
        ;addBoxCollidable(objects(),   (x),   (y),   (0),   90, 90, 90,   RGBA(55+Random(200), 55+Random(200), 55+Random(200), 55+Random(200)))
        
        colorLines = RGBA(55+Random(200), 55+Random(200), 55+Random(200), 55+Random(200))
        colorFaces = RGBA(55+Random(200), 55+Random(200), 55+Random(200), 55+Random(200))
        *object = createObject( (x),   (y),   (0),   colorLines, colorFaces, properties)
        
        ;setBoxCollider(*object,  -w2, w2,  -#w, 0,  0, 0)
        
        addFace(*object\faces())
        addNodeByPos(*object\faces()\nodes(), -w2, -w2, 0+Random(0))
        addNodeByPos(*object\faces()\nodes(),  w2, -w2, 0+Random(0))
        addNodeByPos(*object\faces()\nodes(),  w2,  w2, 0+Random(0))
        addNodeByPos(*object\faces()\nodes(), -w2,  w2, 0+Random(0))
        addNodeByPos(*object\faces()\nodes(), -w2, -w2, 0+Random(0))
      Next
    Next
    ;}
  EndIf
  
  If 01
    ;{ test objects (shot collision)
    app\debObj1 = createBoxCollidable(100,  500, 0, 100, 10, 200, $aaffffff, $aa00ff00, #property_isShootable)
    app\debObj2 = createBoxCollidable(100, 1000, 0, 100, 10, 200, $aaffffff, $aa00ff00, #property_isShootable)
    app\debObj3 = createBoxCollidable(100, 1500, 0, 100, 10, 200, $aaffffff, $aa00ff00, #property_isShootable)
    ;}
  EndIf
  
  If 01
    ;{ normal
    Define nk = 10000
    Define ni = 20
    Define xSize = 100
    Define ySize = 100
    Define.f faceX, faceY
    #iFront = 0
    #iRear = 1
    Dim height.f(ni+1, #iRear) ; stores z for each node of a horizontal row of segments. one more node than segments. two rows for rear and front.
    Define k, i
    Define x, y
    Define.f left, right
    Protected *object2.sObject
    properties = 0
    
    For k=0 To nk ; create object into far direction (+y), sort later
      
      If 0
        ;{ ground tiles
        For i=0 To ni
          x = (i - ni/2) * xSize
          y = k * ySize
          
          ; quick hack to test one-object-per-row as opposed to one-object-per-face (adding faces manually to single-object-row)
          If i=0
            *object2 = createObject( (x),   (y),   (0),   $aa00ff00, $aaff6666, properties)
            faceX = 0
            faceY = 0
          Else
            faceX = x - *object2\pos\x
            faceY = y - *object2\pos\y
          EndIf
          
          addFace(*object2\faces())
          left = -xSize/2
          right = xSize/2
          If i=0
            left = -1000000
          EndIf
          If i=ni
            right = 1000000
          EndIf
          addNodeByPos(*object2\faces()\nodes(), faceX +  left, faceY +  -ySize, height(i+0, #iFront))
          addNodeByPos(*object2\faces()\nodes(), faceX + right, faceY +  -ySize, height(i+1, #iFront))
          addNodeByPos(*object2\faces()\nodes(), faceX + right, faceY +       0, height(i+1, #iRear))
          addNodeByPos(*object2\faces()\nodes(), faceX +  left, faceY +       0, height(i+0, #iRear))
          addNodeByPos(*object2\faces()\nodes(), faceX +  left, faceY +  -ySize, height(i+0, #iFront))
          
          ;*object2\properties | #property_isShootable
          ;setBoxCollider(*object2,  -1000000, 1000000,  -ySize, 0,  0, 0)
        Next
        ;}
      EndIf
      
      If 0
        ;{ randomize ground height
        ; use current rear as next front
        For i=0 To ni+1
          height(i, #iFront) = height(i, #iRear)
        Next
        
        ; now rear and front are identical
        Define.f smooth1 = 0.0
        Define.f smooth2 = 1.0 - 2.0 * smooth1
        Define.f smooth3 = 1.0 - 1.0 * smooth1
        For i=0 To ni+1
          Select i
            Case 0 :         height(i, #iRear) = 0
            Case 1 :         height(i, #iRear) = 0
            Case 2 :         height(i, #iRear) =                                    (smooth3 * height(i, #iFront)) + (smooth1 * height(i+1, #iFront))
            Case 3 To ni-1 : height(i, #iRear) = (smooth1 * height(i-1, #iFront)) + (smooth2 * height(i, #iFront)) + (smooth1 * height(i+1, #iFront))
            Case ni-1 :      height(i, #iRear) = (smooth1 * height(i-1, #iFront)) + (smooth3 * height(i, #iFront))
    ;         Case 2 :         height(i, #iRear) =                                (0.80 * height(i, #iFront)) + (0.20 * height(i+1, #iFront))
    ;         Case 3 To ni-1 : height(i, #iRear) = (0.25 * height(i-1, #iFront)) + (0.50 * height(i, #iFront)) + (0.25 * height(i+1, #iFront))
    ;         Case ni-1 :      height(i, #iRear) = (0.20 * height(i-1, #iFront)) + (0.80 * height(i, #iFront))
            Case ni+0 :      height(i, #iRear) = 0
            Case ni+1 :      height(i, #iRear) = 0
          EndSelect
        Next
        
      ;   Debug "----------"
        
        ; modify rear heights
        Define.f range, fRand, fCenter
        range = 200.0
        For i=0+2 To ni+1-2
          fCenter = 1 - (Abs((i-2) - (ni+1-2-2)/2) / ((ni+1-2-2)/2))                  ; 0..1..0 factor to amplify center
          ;fCenter = Pow(fCenter, 0.1)
          ;Debug fCenter
          fRand = Random(1000) / 1000.0                                ; 0..1 factor to apply range
          ;debnug fRand
          height(i, #iRear) = height(i, #iRear) + ((-range/2 + (range * fRand)) * fCenter)
        Next
        
    ;     If k % 10 = 0
    ;       height(2+Random(ni+1-4), #iRear) + 1000
    ;     EndIf
    ;     If (k+5) % 10 = 0
    ;       height(2+Random(ni+1-4), #iRear) - 1000
    ;     EndIf
        ;}
      EndIf
      
      If 1
        ;{ ground boxes ('skyscrapers') with variable height
        If k % 1 = 0
          i = 1 + Random(ni-2)
          x = (i - ni/2) * xSize
          y = k * ySize
          Define colorLines = RGBA(55+Random(200), 55+Random(200), 55+Random(200), 55+Random(200))
          Define colorFaces = RGBA(55+Random(200), 55+Random(200), 55+Random(200), 55+Random(200))
          Define zSize = 40*Random(10)
          properties = #property_isShootable
          createBoxCollidable(x, y, zSize/2, xSize*(1+Random(0)), ySize, zSize, colorLines, colorFaces, properties)
          ;createBox(x, y, zSize/2, xSize*(1+Random(0)), ySize, zSize, colorLines, colorFaces)
        EndIf
        ;}
      EndIf
      
    Next
    ;}
  EndIf
  
  
  If 1
    ;{ add player ship
    properties = #property_isMovable ; (set movable to reset posPrevious)
    app\player\ship = createShip(0, 0, 0,  30, 30, 5,  $ff0000ff, $3300ff00, properties)
    
    ; shot spawn point objects
    If app\debugSpawnPoints
      color = $ffffffff
;       Shared *debugSpawnLeft, *debugSpawnRight
      properties = 0
      app\player\debugSpawnLeft = createBox(0, 0, 0,  2,2,2, color, color, properties)
      app\player\debugSpawnRight = createBox(0, 0, 0,  2,2,2, color, color, properties)
    EndIf
    colorLines = $aaffffff
    colorFaces = $44ff8888
    properties = #property_isMovable
    app\player\sight = createBoxCollidable(0, 0, 0,  30,0,2, colorLines, colorFaces, properties)
    app\player\sight\rotate = #True
    
    ;}
  EndIf
  
  If 0
    ;{ add enemy ship
    If 00
      ; single test ship
      properties = #property_isMovable ; (set movable to reset posPrevious)
      properties | #property_isEnemy
      *object = createShip(-50, 2250, -40,  30, 30, 5,  $ff0000ff, $3300ff00, properties)
      setRot(*object, *object\rot\ax+Radian(10), *object\rot\ax, (*object\rot\az - Radian(180)), #previous_reset)
      *object\speed\y = 300
      updateDebugBox(*object, #False, #True) ; debugBox pos should be already up-to-date
    Else
      ; multiple ships
      Define sn = 100
      Define distStep = 1500
      Define si
      For si = 0 To sn-1
        properties = #property_isMovable ; (set movable to reset posPrevious)
        properties | #property_isEnemy
        *object = createShip(-500+Random(1000), distStep * si, Random(1000),  100, 100, 100,  $ff0000ff, $3300ff00, properties)
        setRot(*object, *object\rot\ax+Radian(10), *object\rot\ax, (*object\rot\az - Radian(180)), #previous_reset)
        *object\speed\y = 400
        updateDebugBox(*object, #False, #True) ; debugBox pos should be already up-to-date
        
        Assert(app\player\ship)
        If Random(3) = 0
          *object\targetObject = app\player\ship ; (to make enemy switch to not-attacking when coming into view)
        EndIf
      Next
    EndIf
    ;}
  EndIf
  
EndProcedure
; IDE Options = PureBasic 5.70 LTS beta 2 (Linux - x64)
; CursorPosition = 13
; FirstLine = 13
; Folding = P--
; Markers = 305
; EnableXP