﻿
XIncludeFile "drawing.h.pbi"

XIncludeFile "app.h.pbi"
XIncludeFile "thread.h.pbi"

; (debug)
Declare spaceToView(x.f, y.f, z.f, *pos.sVec3)


Procedure addDrawingOperation(drawingOperation, argF0.f, argF1.f, argI0, argI1, argS0.s)
  Shared drawingOperations()
  If Not NextElement(drawingOperations())
    AddElement(drawingOperations())
  EndIf
  drawingOperations()\drawingOperation = drawingOperation
  drawingOperations()\argsF[0] = argF0
  drawingOperations()\argsF[1] = argF1
  drawingOperations()\argsI[0] = argI0
  drawingOperations()\argsI[1] = argI1
  drawingOperations()\argsS[0] = argS0
EndProcedure

Procedure setDrawingOperations()
;   Shared objects(), *objectsStart, *objectsEnd
;   Shared cam, camFar
  Shared semaphoreMain, semaphoreDraw
  Shared drawingOperations()
;   Shared ww, wh, font
;   Shared debugPositions
  
  ;Shared cntObjects, cntFaces, cntNodes
  ; cntObjects = 0
  ; cntFaces = 0
  ; cntNodes = 0
  
  Define previousNodeVisible
  Define moved
  Define run
  
  If #threaded
    WaitSemaphore(semaphoreMain)
  EndIf
;   Shared canvas, canvasImage
  SetGadgetAttribute(app\canvas, #PB_Canvas_Image, ImageID(app\canvasImage))

  ResetList(drawingOperations())
  ;ClearList(drawingOperations())
  
  ; LOOP OBJECTS
  ChangeCurrentElement(app\objects(), app\objectsStart)
  PreviousElement(app\objects())
  While NextElement(app\objects())
    
    previousNodeVisible = #False
    
    ; clip objects
    If (app\objects()\pos\y < (app\cam\y + app\camFar)) And (app\objects()\pos\y > app\cam\y)
      
      ;cntObjects + 1
      
      ; LOOP RUN
      ; run 1 = fill faces
      ; run 2 = stroke lines
      For run = 1 To 2
        
        ; LOOP FACES
        ForEach app\objects()\faces()
          
          previousNodeVisible = #False
          
          ;If run = 1
          ;  cntFaces + 1
          ;EndIf
          
          ; LOOP NODES
          ForEach app\objects()\faces()\nodes()
            
            ;If run = 2
            ;  cntNodes + 1
            ;EndIf
            
            ; add line
            moved = #False
            If app\objects()\faces()\nodes()\yDistNorm <= 1.0
              If app\objects()\faces()\nodes()\yDistNorm > 0.0
                If previousNodeVisible
                  addDrawingOperation(#drawingOperation_line, app\ww/2 + app\objects()\faces()\nodes()\x2d, app\wh/2 + app\objects()\faces()\nodes()\y2d, 0, 0, "")
                  moved = #True
                EndIf
              EndIf
            EndIf
            
            ; add move
            If Not moved
              addDrawingOperation(#drawingOperation_move, app\ww/2 + app\objects()\faces()\nodes()\x2d, app\wh/2 + app\objects()\faces()\nodes()\y2d, #PB_Path_Default, 0, "")
            EndIf
            
            If app\objects()\faces()\nodes()\yDistNorm <= 1.0 And app\objects()\faces()\nodes()\yDistNorm > 0.0
              previousNodeVisible = #True
            EndIf
          Next ; (LOOP NODES)
          
          ; fill face
          If run = 1
            addDrawingOperation(#drawingOperation_color, 0, 0, RGBA(Red(app\objects()\colorFaces), Green(app\objects()\colorFaces), Blue(app\objects()\colorFaces), Alpha(app\objects()\colorFaces) * app\objects()\fade), 0, "")
            addDrawingOperation(#drawingOperation_fill, 0, 0, #PB_Path_Preserve, 0, "")
            addDrawingOperation(#drawingOperation_reset, 0, 0, 0, 0, "")
          EndIf
          
        Next ; (LOOP FACES)
        
        ; stroke all faces/nodes
        If run = 2
          Protected colorLines
          colorLines = app\objects()\colorLines
          If app\objects()\targeted
            colorLines = $ffffffff
          EndIf
          addDrawingOperation(#drawingOperation_color, 0, 0, RGBA(Red(colorLines), Green(colorLines), Blue(colorLines), Alpha(colorLines) * app\objects()\fade * 0.1), 0, "")
          addDrawingOperation(#drawingOperation_stroke, 0, 0, 8, #PB_Path_RoundCorner | #PB_Path_RoundEnd | #PB_Path_Preserve, "")
          
          addDrawingOperation(#drawingOperation_color, 0, 0, RGBA(Red(colorLines), Green(colorLines), Blue(colorLines), Alpha(colorLines) * app\objects()\fade * 0.2), 0, "")
          addDrawingOperation(#drawingOperation_stroke, 0, 0, 4, #PB_Path_RoundCorner | #PB_Path_RoundEnd | #PB_Path_Preserve, "")
          
          addDrawingOperation(#drawingOperation_color, 0, 0, RGBA(Red(colorLines), Green(colorLines), Blue(colorLines), Alpha(colorLines) * app\objects()\fade * 1.0), 0, "")
          addDrawingOperation(#drawingOperation_stroke, 0, 0, 1, #PB_Path_RoundCorner | #PB_Path_RoundEnd | #PB_Path_Preserve, "")
          
          addDrawingOperation(#drawingOperation_reset, 0, 0, 0, 0, "")
        EndIf
        
      Next ; (LOOP RUN)
      
      ;{ debug object position
      If app\debugPositions
        addDrawingOperation(#drawingOperation_move, (app\ww/2 + app\objects()\pos\x2d), (app\wh/2 + app\objects()\pos\y2d), #PB_Path_Default, 0, "")
        addDrawingOperation(#drawingOperation_box, (app\ww/2 + app\objects()\pos\x2d), (app\wh/2 + app\objects()\pos\y2d), 1, 1, "")
        
        addDrawingOperation(#drawingOperation_font, 0, 0, app\font, 10, "")
        addDrawingOperation(#drawingOperation_text, 0, 0, 0, 0, "pos : " + StrF(app\objects()\pos\x, 0) + ", " + StrF(app\objects()\pos\y , 0) + ", " + StrF(app\objects()\pos\z, 0))
        
        addDrawingOperation(#drawingOperation_move, 0, 10, #PB_Path_Relative, 0, "")
        addDrawingOperation(#drawingOperation_text, 0, 0, 0, 0, "rot : " + StrF(Degree(app\objects()\rot\ax), 0) + ", " + StrF(Degree(app\objects()\rot\ay), 0) + ", " + StrF(Degree(app\objects()\rot\az), 0))
        
        addDrawingOperation(#drawingOperation_move, 0, 10, #PB_Path_Relative, 0, "")
        addDrawingOperation(#drawingOperation_text, 0, 0, 0, 0, "index : " + Str(ListIndex(app\objects())))
        
        addDrawingOperation(#drawingOperation_move, 0, 10, #PB_Path_Relative, 0, "")
        addDrawingOperation(#drawingOperation_text, 0, 0, 0, 0, " yDistNorm : " + StrF(app\objects()\pos\yDistNorm, 2))
        
        addDrawingOperation(#drawingOperation_move, 0, 10, #PB_Path_Relative, 0, "")
        addDrawingOperation(#drawingOperation_text, 0, 0, 0, 0, " distance : " + StrF(app\objects()\pos\y - app\cam\y, 2))
        
        addDrawingOperation(#drawingOperation_move, 0, 10, #PB_Path_Relative, 0, "")
        addDrawingOperation(#drawingOperation_text, 0, 0, 0, 0, " travelled y : " + StrF(app\objects()\travelledSpaceMin\y, 2) + ".." + StrF(app\objects()\travelledSpaceMax\y, 2))
        
        addDrawingOperation(#drawingOperation_color, 0, 0, $ddffffff, 0, "")
        addDrawingOperation(#drawingOperation_fill, 0, 0, #PB_Path_Preserve, 0, "")
        
        addDrawingOperation(#drawingOperation_reset, 0, 0, 0, 0, "")
      EndIf
      ;}
      
    EndIf
    
    If app\objects() = app\objectsEnd
      Break
    EndIf
  Wend ; (LOOP OBJECTS)
  
  ; --------------------
  ; (debug)
  ; get 2d pos
  ForEach debVec()
    spaceToView(debVec()\x, debVec()\y, debVec()\z, @ debVec() )
  Next
  ; lines
  If FirstElement(debVec())
    addDrawingOperation(#drawingOperation_move, app\ww/2 + debVec()\x2d, app\wh/2 + debVec()\y2d, #PB_Path_Default, 0, "")
    While NextElement(debVec())
      If 1;ListIndex(debVec()) < ElapsedMilliseconds() / 2000
        addDrawingOperation(#drawingOperation_line, app\ww/2 + debVec()\x2d, app\wh/2 + debVec()\y2d, 0, 0, "")
      EndIf
    Wend
    addDrawingOperation(#drawingOperation_color, 0, 0, $ffaaaaff, 0, "")
    addDrawingOperation(#drawingOperation_stroke, 0, 0, 2, #PB_Path_RoundCorner | #PB_Path_RoundEnd | #PB_Path_Preserve, "")
    addDrawingOperation(#drawingOperation_reset, 0, 0, 0, 0, "")
  EndIf
  ; text
  addDrawingOperation(#drawingOperation_font, 0, 0, app\font, 10, "")
  ForEach debVec()
    addDrawingOperation(#drawingOperation_move, app\ww/2 + debVec()\x2d, app\wh/2 + debVec()\y2d, #PB_Path_Default, 0, "")
    addDrawingOperation(#drawingOperation_text, 0, 0, 0, 0, "[" + StrF(debVec()\x, 0) + ", " + StrF(debVec()\y , 0) + ", " + StrF(debVec()\z, 0) + "; " + debVec()\x2d + ", " + debVec()\y2d + "]")
  Next
  addDrawingOperation(#drawingOperation_color, 0, 0, $ffffffff, 0, "")
  addDrawingOperation(#drawingOperation_fill, 0, 0, #PB_Path_Preserve, 0, "")
  addDrawingOperation(#drawingOperation_reset, 0, 0, 0, 0, "")
  ClearList(debVec())
  ; --------------------
  
  addDrawingOperation(#drawingOperation_move, 0, app\wh-10, #PB_Path_Default, 0, "")
  
  addDrawingOperation(#drawingOperation_box, 0, app\wh-10, 100, 10, "")
  addDrawingOperation(#drawingOperation_color, 0, 0, $ddffffff, 0, "")
  addDrawingOperation(#drawingOperation_stroke, 0, 0, 1, #PB_Path_Preserve, "")
  addDrawingOperation(#drawingOperation_reset, 0, 0, 0, 0, "")
  
  addDrawingOperation(#drawingOperation_box, 0, app\wh-10, app\player\energy, 10, "")
  addDrawingOperation(#drawingOperation_color, 0, 0, $ddffffff, 0, "")
  addDrawingOperation(#drawingOperation_fill, 0, 0, #PB_Path_Preserve, 0, "")
  addDrawingOperation(#drawingOperation_reset, 0, 0, 0, 0, "")
  
  addDrawingOperation(#drawingOperation_stop, 0, 0, 0, 0, "")
  ;While NextElement(drawingOperations())
  ;  DeleteElement(drawingOperations())
  ;Wend
  
  If #threaded
    SignalSemaphore(semaphoreDraw)
  EndIf
  
EndProcedure

Procedure draw(*app.sApplication)
  Shared semaphoreDraw
  Shared semaphoreMain
  Shared exitDrawThread
  ;Shared canvas, canvasImage, ww, wh, mouseMoveThreshold
  Shared drawingOperations()
  ;Shared font, FR$, cam, camFar, camDepth, blur, zoom
  ;Protected FR_local, FRt_local, FR_local$
  
  Repeat
    If #threaded
      WaitSemaphore(semaphoreDraw)
    EndIf
      
    StartVectorDrawing(ImageVectorOutput(*app\canvasImage))
      
      VectorSourceColor(RGBA(0, 0, 0, 255 * (1 - *app\blur)))
      FillVectorOutput()
      
      ForEach drawingOperations()
        Select drawingOperations()\drawingOperation
          Case #drawingOperation_move   :   MovePathCursor(drawingOperations()\argsF[0], drawingOperations()\argsF[1], drawingOperations()\argsI[0])
          Case #drawingOperation_line   :   AddPathLine(drawingOperations()\argsF[0], drawingOperations()\argsF[1])
          Case #drawingOperation_box    :   AddPathBox(drawingOperations()\argsF[0], drawingOperations()\argsF[1], drawingOperations()\argsI[0], drawingOperations()\argsI[1])
          Case #drawingOperation_font   :   VectorFont(FontID(drawingOperations()\argsI[0]), drawingOperations()\argsI[1])
          Case #drawingOperation_text   :   AddPathText(drawingOperations()\argsS[0])
          Case #drawingOperation_color  :   VectorSourceColor(drawingOperations()\argsI[0])
          Case #drawingOperation_fill   :   FillPath(drawingOperations()\argsI[0])
          Case #drawingOperation_stroke :   StrokePath(drawingOperations()\argsI[0], drawingOperations()\argsI[1])
          Case #drawingOperation_reset  :   ResetPath()
          Case #drawingOperation_stop   :   Break
        EndSelect
      Next
      
      ; FR_local+1;{
      ; If ElapsedMilliseconds()>FRt_local
      ;   FRt_local=ElapsedMilliseconds()+500
      ;   FR_local$=Str(FR_local*2)
      ;   FR_local=0
      ; EndIf;}
      
      ; mouseMoveThreshold box
      AddPathBox(*app\ww/2-*app\mouseMoveThreshold, *app\wh/2-*app\mouseMoveThreshold, 2**app\mouseMoveThreshold, 2**app\mouseMoveThreshold)
      VectorSourceColor($66ffaaaa)
      StrokePath(1)
      ResetPath()
      
      ; debug info
      VectorFont(FontID(*app\font), 10)
      MovePathCursor(10, 10) : AddPathText("fps (main): "+*app\FR$)
      ;MovePathCursor(10, 20) : AddPathText("fps (draw): "+FR_local$)
      MovePathCursor(10, 30) : AddPathText("camX : "+StrF(*app\cam\x,2))
      MovePathCursor(10, 40) : AddPathText("camY : "+StrF(*app\cam\y,2))
      MovePathCursor(10, 50) : AddPathText("camZ : "+StrF(*app\cam\z,2))
      MovePathCursor(10, 60) : AddPathText("camFar : "+StrF(*app\camFar,2))
      MovePathCursor(10, 70) : AddPathText("camDepth : "+StrF(*app\camDepth,2))
      MovePathCursor(10, 80) : AddPathText("zoom : "+StrF(*app\zoom,2))
      MovePathCursor(10, 90) : AddPathText("blur : "+StrF(*app\blur,2))
      VectorSourceColor($ddffffff)
      FillPath()
      
    StopVectorDrawing()
    
    If #threaded
      SignalSemaphore(semaphoreMain)
    EndIf
    
    If Not #threaded
      ProcedureReturn
    EndIf
    
  Until exitDrawThread
  
EndProcedure
; IDE Options = PureBasic 5.70 LTS beta 2 (Linux - x64)
; CursorPosition = 7
; FirstLine = 159
; Folding = -
; EnableXP