﻿
; analyzer:disable

; --------------------------------------------------------------------------------------------------

; for debugger-only versions

CompilerIf Not #PB_Compiler_Debugger
;   MessageRequester("3d test", "debugger only")
;   End
CompilerEndIf

; --------------------------------------------------------------------------------------------------

EnableExplicit

ElapsedMilliseconds()
RandomSeed(0)

; --------------------------------------------------------------------------------------------------

Structure sTimer
;   timer.i
;   time.i
;   deltatime.i
EndStructure

;.........................................................................................
;                                                                                        .
;  viewed as on screen, right hand system                                                .
;                                                                                        .
;             +z                                                                         .
;              |   +y                                                                    .
;              |  /                                                                      .
;              | /                                                                       .
;              |/                                                                        .
;     -x ______0______ +x                                                                .
;             /|                                                                         .
;            / |        ^                                                                .
;           /  |       /  - cam looks in direction of +y                                 .
;         -y   |      /   - mouse moves cam on x/y plane (up,down,left,right)            .
;             -z     /    - ship moves forward into +y and backward into -y              .
;                                                                                        .
;.........................................................................................

; [structures]

; --------------------------------------------------------------------------------------------------

; Define cntObjects
; Define cntFaces
; Define cntNodes
; Define cntObjectsTraversed

;{ measure time

  ; Define tMainA.sTimer
  ; Define tMainB.sTimer
  ; Define tThread.sTimer

;     tThread\timer = ElapsedMilliseconds()
;       ...
;     tThread\deltatime = (ElapsedMilliseconds() - tThread\timer)
;     tThread\time + tThread\deltatime
;     Debug "                                               tThread\deltatime: " + tThread\deltatime
;}

; --------------------------------------------------------------------------------------------------

XIncludeFile "assert.pbi"
XIncludeFile "math.pbi"

XIncludeFile "thread.h.pbi"
XIncludeFile "key.h.pbi"
XIncludeFile "vec.h.pbi"
XIncludeFile "transition.h.pbi"
XIncludeFile "drawing.h.pbi"
XIncludeFile "rotation.h.pbi"
XIncludeFile "object.h.pbi"
XIncludeFile "player.h.pbi"
XIncludeFile "app.h.pbi"

XIncludeFile "thread.pbi"
XIncludeFile "key.pbi"
XIncludeFile "vec.pbi"
XIncludeFile "transition.pbi"
XIncludeFile "drawing.pbi"
XIncludeFile "rotation.pbi"
XIncludeFile "object.pbi"
XIncludeFile "player.pbi"
XIncludeFile "app.pbi"
XIncludeFile "cam.pbi"

; --------------------------------------------------------------------------------------------------




Procedure spaceToView(x.f, y.f, z.f, *pos.sVec3)
;   Shared cam, camFar, camDepth, zoom
;   Shared ww, wh
  
  ; translate node coords from absolute to cam-relative
  x = x - app\cam\x
  y = y - app\cam\y
  z = z - app\cam\z
  
  ; 2d position for nodes behind cam are not updated, make sure the are not drawn/visible
  If y > 0
    *pos\x2d = ( x / y) * app\camDepth * app\zoom
    *pos\y2d = (-z / y) * app\camDepth * app\zoom
  EndIf
  *pos\yDistNorm = (y / app\camFar)
  
EndProcedure



Procedure fadeByDistance(*object.sObject)
;   Shared *playerObject
  
  #fade_rangeFar = 0.05
  #fade_rangeNear = 0.1
  
  #fade_valueNormal = 1.0
  #fade_valueBeyond  = 0.0
  #fade_valueBehind  = 0.0
  
  With *object
    \fade = #fade_valueNormal
    
    If *object <> app\player\ship
      
      If \pos\yDistNorm > 1                            ; beyond far plane
        \fade = #fade_valueBeyond
        
      ElseIf \pos\yDistNorm > (1 - #fade_rangeFar)     ; far fade (fade in)
        \fade = (1 - \pos\yDistNorm) / #fade_rangeFar
        
      ElseIf \pos\yDistNorm < #fade_rangeNear
        \fade = \pos\yDistNorm / #fade_rangeNear       ; near fade (fade out)
        
      ElseIf \pos\yDistNorm < 0
        \fade = #fade_valueBehind                      ; near fade (fade out)
        
      EndIf
    EndIf
  EndWith
EndProcedure

Procedure setObjectPositions()
;   Shared objects(), *objectsStart, *objectsEnd
;   Shared cam, camFar
  Define dx.f, dy.f, dz.f
  ;Define ay.f, ax.f
  
  ; LOOP OBJECTS
  ChangeCurrentElement(app\objects(), app\objectsStart)
  PreviousElement(app\objects())
  While NextElement(app\objects())
    
    ; clip objects
    If (app\objects()\pos\y < (app\cam\y + app\camFar)) And (app\objects()\pos\y > app\cam\y)
      
      ; ---------------------------------------------
      ; get object position
      
      spaceToView(app\objects()\pos\x, 
                  app\objects()\pos\y, 
                  app\objects()\pos\z, 
                  @ app\objects()\pos)
      ; ---------------------------------------------
      
      fadeByDistance(app\objects())
      If app\objects()\properties & #property_isDebris
        app\objects()\fade * app\objects()\fadeDebris
      EndIf
      
      ; LOOP FACES
      ForEach app\objects()\faces()
        
        ; LOOP NODES
        ForEach app\objects()\faces()\nodes()
          
          ; ---------------------------------------------
          ; get [rotated] node position
          
          If app\objects()\rotate
            
            rotate(app\objects()\faces()\nodes()\x, 
                   app\objects()\faces()\nodes()\y, 
                   app\objects()\faces()\nodes()\z,  
                   app\objects()\rot\ax, 
                   app\objects()\rot\ay, 
                   app\objects()\rot\az, 
                   @ dx, @ dy, @ dz)
            
            ; object position + rotated node position
            spaceToView(app\objects()\pos\x + dx, 
                        app\objects()\pos\y + dy, 
                        app\objects()\pos\z + dz, 
                        @ app\objects()\faces()\nodes())
          Else
            
            ; object position + node position
            spaceToView(app\objects()\pos\x + app\objects()\faces()\nodes()\x, 
                        app\objects()\pos\y + app\objects()\faces()\nodes()\y, 
                        app\objects()\pos\z + app\objects()\faces()\nodes()\z, 
                        @ app\objects()\faces()\nodes())
          EndIf
          ; ---------------------------------------------
          
        Next ; (LOOP NODES)
        
      Next ; (LOOP FACES)
      
    EndIf
    
    If app\objects() = app\objectsEnd
      Break
    EndIf
  Wend ; (LOOP OBJECTS)
  
EndProcedure

; Procedure asdasd(*speed.Float, positive) here
; EndProcedure

Procedure updatePlayer()
;   Shared *playerObject, perSecond
  Shared key
;   Shared mouseXForce, mouseYForce
  
  Static.f playerSpeedLastY
  Static.q playerSpeedLastTime
  Static.q playerSpeedPhaseoutTime = 1000
  Define.f f
  
  #thrustNormal = 1000
  #thrustReverse = 3000
  #speedMax = 1000
  
  ; note: perSecond is only used for modification or later application of speed. setting speed
  ; to absolute values like #speedMax should not be timebased.
  
  With app\player\ship\speed
    
    ; forward
    If key\forward\pressed
      If \y < 0
        \y + (#thrustReverse * app\perSecond)  ; (reverse speed)
      Else
        \y + (#thrustNormal * app\perSecond)   ; forward
      EndIf
      playerSpeedLastTime = 0
      
    ; backward
    ElseIf key\backward\pressed
      If \y > 0
        \y - (#thrustReverse * app\perSecond)  ; (reverse speed)
      Else
        \y - (#thrustNormal * app\perSecond)   ; backward
      EndIf
      playerSpeedLastTime = 0
      
    EndIf
    
    ; clip speed
    If \y > #speedMax
      \y = #speedMax
    EndIf
    
    ; start speed phase out
    If key\forward\up Or key\backward\up
      playerSpeedLastY = \y
      playerSpeedLastTime = ElapsedMilliseconds()
    EndIf
    
    ; phase out speed
    If playerSpeedLastTime
      f = 1 - ((ElapsedMilliseconds() - playerSpeedLastTime) / playerSpeedPhaseoutTime)
      If f < 0
        playerSpeedLastTime = 0
        f = 0
      EndIf
      f = Pow(f, 2)
      \y = playerSpeedLastY * f
    EndIf
    
  EndWith
  
  #power = 1.3
  
  ; rotate player
  #forceDamp = 0.00004
  setRot(app\player\ship, 
         - PowSigned(app\mouseYForce, #power) * #forceDamp * (#PI*2),   ; pitch (up/down)
         - PowSigned(app\mouseXForce, #power) * #forceDamp * (#PI*2),   ; left/right
         PowSigned(app\mouseXForce, #power) * #forceDamp * (#PI*2) )    ; left/right
  
;   Debug "---"
;   Debug *playerObject\rot\ax
;   Debug *playerObject\rot\ay
;   Debug *playerObject\rot\az
  
  ; sort/update?
  
EndProcedure


Procedure addShot(*parentObject.sObject)
;   Shared *playerObject, cam, debugColliders
  Protected *shotObject.sObject
  
  Static i
  Static spawnPos.sVec3
  Static properties = #property_isBullet | #property_isMovable
  Static.sVec3 shotSpeedRelative
  
  For i=1 To 2
    
    Select i
        
      Case 1 :               ; left spawn point
        rotate(-15, -5, 0,  
               *parentObject\rot\ax, 
               *parentObject\rot\ay, 
               *parentObject\rot\az, 
               @ spawnPos\x, 
               @ spawnPos\y, 
               @ spawnPos\z)
        
      Case 2 :               ; right spawn point
        rotate( 15, -5, 0,  
               *parentObject\rot\ax, 
               *parentObject\rot\ay, 
               *parentObject\rot\az, 
               @ spawnPos\x, 
               @ spawnPos\y, 
               @ spawnPos\z)
    EndSelect
    
    *shotObject = createBoxCollidable( (*parentObject\pos\x + spawnPos\x),   ; (parent object pos + rotated spawn pos) becomes shot pos
                                       (*parentObject\pos\y + spawnPos\y), 
                                       (*parentObject\pos\z + spawnPos\z), 
                                       1, 20, 1,                             ; [shot size]
                                       $aaffffff, $aaffffff, 
                                       properties)
    
    *shotObject\rotate = #True
    setRotByVec(*shotObject, *parentObject\rot, #previous_reset)
    
    shotSpeedRelative\x = 0.0
    shotSpeedRelative\y = app\speedShot
    shotSpeedRelative\z = 0.0
    vecSetByVec(*shotObject\speed, *parentObject\speed) ; set to parent speed
    vecAdd(*shotObject\speed, @ shotSpeedRelative)      ; add relative speed
    
    updateDebugBox(*shotObject, #True, #True)
    *shotObject\parentObject = *parentObject
  Next
  
EndProcedure

Procedure f()
  
EndProcedure

Procedure processEnemies()
;   Shared objects(), *objectsStart, *objectsEnd, *playerObject
  Static.sObject *enemy
  Static.sVec3 relPos
  Static.sRot3 absRot, relRot
  Static restartTransition
  
  ChangeCurrentElement(app\objects(), app\objectsStart)
  PreviousElement(app\objects())
  While NextElement(app\objects())
    
    If app\objects()\properties & #property_isMovable
      If app\objects()\properties & #property_isEnemy
        *enemy = app\objects()
        
        ; shoot
        If *enemy\targetObject And *enemy\timerNewShot < ElapsedMilliseconds()
          *enemy\timerNewShot = ElapsedMilliseconds() + app\timeEnemyNewShot
          addShot(*enemy) ; maybe don't modify objects() list
        EndIf
        
        restartTransition = #False
        
        ; get new target
        If *enemy\timerAiNewTarget < ElapsedMilliseconds()
          *enemy\timerAiNewTarget = ElapsedMilliseconds() + app\timeEnemyNewTarget
          
          If Not *enemy\targetObject And (*enemy\pos\y > (app\player\ship\pos\y + 200))
            ; target player pos
            *enemy\targetObject = app\player\ship
            vecSet( @ *enemy\targetPos,  *enemy\targetObject\pos\x,  *enemy\targetObject\pos\y,  *enemy\targetObject\pos\z )
          Else
            
            If *enemy\targetObject And (Not *enemy\timerAiKeepTarget)
              ; keep player as target
              *enemy\timerAiKeepTarget = ElapsedMilliseconds() + app\timeKeepEnemyTargetPlayer
              
            ElseIf *enemy\targetObject And (*enemy\timerAiKeepTarget < ElapsedMilliseconds())
              ; target arbitrary pos
              *enemy\targetObject = #Null
              *enemy\timerAiKeepTarget = 0
              vecSet( @ *enemy\targetPos,
                      *enemy\pos\x - 2000 + Random(4000),  ; left/right
                      *enemy\pos\y - 3000 - Random(3000),  ; towards player
                      *enemy\pos\z - 4000 + Random(8000) ) ; up/down
            ElseIf *enemy  
            EndIf
          EndIf
          
          restartTransition = #True
        EndIf
        
        ; update target pos
        If *enemy\targetObject
          vecSet( @ *enemy\targetPos,  *enemy\targetObject\pos\x,  *enemy\targetObject\pos\y,  *enemy\targetObject\pos\z )
        EndIf
        ; get relative target pos
        vecMinus( *enemy\targetPos, *enemy\pos, @ relPos )
        
        ; get absolute to-target rotation (i.e. enemy rotation after transition)
        
        Define.f distOnXYPlane, localAX
        ; just use global z-angle (yaw will be applied first in rotate())
        absRot\az = ATan2(relPos\y, relPos\x)
        ; but use relative x-angle (local enemy ship pitch to look up or down towards player ship)
        distOnXYPlane = Sqr((relPos\x * relPos\x) + (relPos\y * relPos\y))
        localAX = ATan2(distOnXYPlane, relPos\z)
        absRot\ax = -localAX ; (pitch upwards is negative ax)
        absRot\ay = 0
        
        If restartTransition Or (*enemy\rotTransitionZ\finished Or *enemy\rotTransitionZ\finished)
          ;Debug "restart"
          Define transitionTime
          If *enemy\targetObject = app\player\ship
            transitionTime = app\timeTransitionEnemyTargetPlayer
          Else
            transitionTime = app\timeTransitionEnemyTargetPosition
          EndIf
          setTransition(*enemy\rotTransitionZ, 
                        *enemy\rot\az, 
                        absRot\az, 
                        normalizeAngle(absRot\az - *enemy\rot\az), 
                        transitionTime)
          setTransition(*enemy\rotTransitionX, 
                        *enemy\rot\ax, 
                        absRot\ax, 
                        normalizeAngle(absRot\ax - *enemy\rot\ax), 
                        transitionTime)
        Else
          ; keep transition start value/time, only update end value (and delta)
          updateTransitionRange(*enemy\rotTransitionZ, *enemy\rotTransitionZ\valueStart, absRot\az, normalizeAngle(absRot\az - *enemy\rotTransitionZ\valueStart))
          updateTransitionRange(*enemy\rotTransitionX, *enemy\rotTransitionX\valueStart, absRot\ax, normalizeAngle(absRot\ax - *enemy\rotTransitionX\valueStart))
        EndIf
        
;         If (*enemy\rotTransitionZ\finished) Or (*enemy\rotTransitionZ\finished)
;         EndIf
        
        If (Not *enemy\rotTransitionZ\finished) Or (Not *enemy\rotTransitionZ\finished)
          updateTransition(*enemy\rotTransitionZ)
          updateTransition(*enemy\rotTransitionX)
          setRot(*enemy, 
                 normalizeAngle(*enemy\rotTransitionX\valueCurrent), 
                 *enemy\rot\ay, 
                 normalizeAngle(*enemy\rotTransitionZ\valueCurrent) )
        EndIf
        
        ; (todo: normalize angle in coll detect interpol)
        
;         ; follow target
;         If *enemy\targetObject
;           direction\x = *enemy\targetObject\pos\x - *enemy\pos\x
;           direction\y = *enemy\targetObject\pos\y - *enemy\pos\y
;           direction\z = *enemy\targetObject\pos\z - *enemy\pos\z
;         Else
;           direction\x = *enemy\targetPos\x - *enemy\pos\x
;           direction\y = *enemy\targetPos\y - *enemy\pos\y
;           direction\z = *enemy\targetPos\z - *enemy\pos\z
;         EndIf
        
        ;Debug "direction: " + direction\x + ", " + direction\y + ", " + direction\z
        
        ;rotation\ax = 0
        ;rotation\ay = 0
        ;rotation\az = 0
        ;rotation\ax = Radian(90)
        ;rotation\ay = Radian(0)
        ;rotation\az = Radian(90)
        ;rotation\ax = ATan2(direction\z, direction\y)
        ;rotation\ay = ATan2(direction\x, direction\z)
        ;rotation\az = ATan2(direction\y, direction\x)
        
;         ; just use global z-angle (yaw will be applied first in rotate())
;         rotation\az = ATan2(direction\y, direction\x)
;         
;         ; but use relative x-angle (local enemy ship pitch to look up or down towards player ship)
;         Define.f distOnXYPlane, localAX
;         distOnXYPlane = Sqr((direction\x * direction\x) + (direction\y * direction\y))
;         localAX = ATan2(distOnXYPlane, direction\z)
;         rotation\ax = -localAX ; (pitch upwards is negative ax)
;         
;         rotation\ay = 0
        
        ;Debug "rotation: " + Degree(rotation\ax) + ", " + Degree(rotation\ay) + ", " + Degree(rotation\az)
        
;         setRotByVec(*enemy, @ rotation)
        
        updateDebugBox(*enemy, #False, #True)
      EndIf
    EndIf
    
    If app\objects() = app\objectsEnd
      Break
    EndIf
  Wend
EndProcedure

Procedure moveObjects()
;   Shared objects(), *playerObject, *objectsStart, *objectsEnd, cam, camFar, perSecond
  Static deltaPos.sVec3, f.f
  
  ChangeCurrentElement(app\objects(), app\objectsStart)
  PreviousElement(app\objects())
  While NextElement(app\objects())
    
    If app\objects()\properties & #property_isMovable
      
      deltaPos\x = (app\objects()\speed\x * app\perSecond)
      deltaPos\y = (app\objects()\speed\y * app\perSecond)
      deltaPos\z = (app\objects()\speed\z * app\perSecond)
      
      ; rotate the speed vector
      rotate(deltaPos\x, deltaPos\y, deltaPos\z,  app\objects()\rot\ax, app\objects()\rot\ay, app\objects()\rot\az,  @ deltaPos\x, @ deltaPos\y, @ deltaPos\z)
      
      ; clip movement at far/near plane (delete shots)
      If app\objects()\properties & #property_isBullet
        If (app\objects()\pos\y + deltaPos\y) >= (app\cam\y + app\camFar)
          f = (((app\cam\y + app\camFar - 2.0) - app\objects()\pos\y) / deltaPos\y)
          deltaPos\y * f
          deltaPos\x * f
          deltaPos\z * f
          deleteObjectLater( @ app\objects() )
        ElseIf (app\objects()\pos\y + deltaPos\y) <= (app\cam\y) ; And  (app\objects() <> app\player\ship)
          f = (((app\cam\y + 2.0) - app\objects()\pos\y) / deltaPos\y)
          deltaPos\y * f
          deltaPos\x * f
          deltaPos\z * f
          deleteObjectLater( @ app\objects() )
        EndIf
      EndIf
      
      ; move
      If Not app\objects() = app\player\sight
        setPos(app\objects(), 
               app\objects()\pos\x + deltaPos\x, 
               app\objects()\pos\y + deltaPos\y, 
               app\objects()\pos\z + deltaPos\z )
        updateTravelledSpace(app\objects())
      EndIf
      
      If app\objects()\properties & #property_isBullet
        Assert(app\objects()\pos\y < (app\cam\y + app\camFar))
        Assert(app\objects()\pos\y > (app\cam\y))
      EndIf
      
      updateDebugBox(app\objects(), #True, Bool(app\objects() = app\player\ship))
      
      If app\objects()\properties & #property_isDebris
        app\objects()\fadeDebris - (app\fadeDebrisPerSecond * app\perSecond)
        If app\objects()\fadeDebris <= 0
          app\objects()\fadeDebris = 0
          deleteObjectLater( @ app\objects() )
        EndIf
      EndIf
    EndIf
    
    If app\objects() = app\objectsEnd
      Break
    EndIf
  Wend
  
  Static sightPos.sVec3
  ; rotate sight root with player
  rotate(0, -27, 0,  
         app\player\ship\rot\ax, 
         app\player\ship\rot\ay, 
         app\player\ship\rot\az, 
         @ sightPos\x, 
         @ sightPos\y, 
         @ sightPos\z)
  
  ;setPosByVec(app\player\sight, app\player\ship\pos, #previous_ignore)
  setPos(app\player\sight,
         app\player\ship\pos\x + sightPos\x,
         app\player\ship\pos\y + sightPos\y,
         app\player\ship\pos\z + sightPos\z,
         #previous_update)
  updateTravelledSpace(app\player\sight)
  
  setRotByVec(app\player\sight, app\player\ship\rot, #previous_update) ; ('update' important for interpolation over sight rotation)
  
EndProcedure

Procedure updateObjectsStartEnd()
;   Shared objects(), *objectsStart, *objectsEnd, cam
  updateObjectsStart(app\objects(), @ app\objectsStart, app\cam\y, app\camFar)
  updateObjectsEnd  (app\objects(), @ app\objectsEnd  , app\cam\y)
  ; ChangeCurrentElement(app\objects(), app\objectsStart)
  ; Debug ListIndex(app\objects())
  ; ChangeCurrentElement(app\objects(), app\objectsEnd)
  ; Debug ListIndex(app\objects())
EndProcedure

; --------------------------------------------------------------------------------------------------

init()

; analyzer:enable

Repeat
  
  ; delattime
  app\perSecond = (ElapsedMilliseconds() - app\frameTime) / 1000.0
  app\frameTime = ElapsedMilliseconds()
  
  ; --------------------------------------
  
  app\FR+1;{ fps
  If ElapsedMilliseconds() > app\FRt
    app\FRt=ElapsedMilliseconds()+500
    app\FR$=Str(app\FR*2)
    app\FR=0
    ;SetWindowTitle(win, "fps:" + FR$ + " cntObjects:" + cntObjects + " cntFaces:" + cntFaces + " cntNodes:" + cntNodes)
    SetWindowTitle(app\win, "fps:" + app\FR$)
  EndIf
  ;}
  
  app\MouseDeltaX = 0
  app\MouseDeltaY = 0
  
  keyReset(key\forward)
  keyReset(key\backward)
  
  Define addShots
  addShots = 0
  
  ;{ events
  If IsWindow(app\win)
    Repeat
      app\event = WindowEvent()
      app\em = EventMenu()
      app\eg = EventGadget()
      app\et = EventType()
      Select app\event
        Case #PB_Event_CloseWindow
          app\quit = #True
        Case #PB_Event_Menu
          Select app\em
          Case 10
            app\quit = #True
          EndSelect
        Case #PB_Event_Gadget
          If app\eg = app\canvas
            Select app\et
              Case #PB_EventType_LeftButtonDown
                app\mouseButtonLeft = #True
                addShots + 1
              Case #PB_EventType_LeftButtonUp
                app\mouseButtonLeft = #False
              Case #PB_EventType_RightButtonDown
                app\mouseButtonRight = #True
              Case #PB_EventType_RightButtonUp
                app\mouseButtonRight = #False
              Case #PB_EventType_MouseWheel
                ;Debug GetGadgetAttribute(canvas, #PB_Canvas_WheelDelta)
              Case #PB_EventType_MouseMove
                app\MouseDeltaX = GetGadgetAttribute(app\canvas, #PB_Canvas_MouseX) - app\mouseX
                app\MouseDeltaY = GetGadgetAttribute(app\canvas, #PB_Canvas_MouseY) - app\mouseY
                app\MouseX = GetGadgetAttribute(app\canvas, #PB_Canvas_MouseX)
                app\MouseY = GetGadgetAttribute(app\canvas, #PB_Canvas_MouseY)
                ;app\MouseX + (0.1 * app\MouseDeltaX)
                ;app\MouseY + (0.1 * app\MouseDeltaY)
                
                app\mouseXForce = (app\MouseX - (app\ww/2))
                If app\mouseXForce > app\mouseMoveThreshold
                  app\mouseXForce - app\mouseMoveThreshold
                ElseIf app\mouseXForce < -app\mouseMoveThreshold
                  app\mouseXForce + app\mouseMoveThreshold
                Else
                  app\mouseXForce = 0
                EndIf
                
                app\mouseYForce = - (app\MouseY - (app\wh/2))  ; (upwards)
                If app\mouseYForce > app\mouseMoveThreshold
                  app\mouseYForce - app\mouseMoveThreshold
                ElseIf app\mouseYForce < -app\mouseMoveThreshold
                  app\mouseYForce + app\mouseMoveThreshold
                Else
                  app\mouseYForce = 0
                EndIf
                
              Case #PB_EventType_KeyDown
                Select GetGadgetAttribute(app\canvas, #PB_Canvas_Key)
                  Case #PB_Shortcut_E    :    app\camDepth + 100
                  Case #PB_Shortcut_D    :    app\camDepth - 100 : If app\camDepth < 0 : app\camDepth = 0 : EndIf
                  Case #PB_Shortcut_R    :    app\camFar + 100
                  Case #PB_Shortcut_F    :    app\camFar - 100 : If app\camFar < 0 : app\camFar = 0 : EndIf
                  Case #PB_Shortcut_T    :    app\zoom = (app\zoom + 0.001) * 1.1
                  Case #PB_Shortcut_G    :    app\zoom =  app\zoom          * 0.9
                  Case #PB_Shortcut_Z    :    app\blur + 0.01 : If app\blur > 1 : app\blur = 1 : EndIf
                  Case #PB_Shortcut_H    :    app\blur - 0.01 : If app\blur < 0 : app\blur = 0 : EndIf
                  Case #PB_Shortcut_M    :    app\debugPositions ! 1
                    
                  Case #PB_Shortcut_Up    :   keySetDown(key\forward)
                  Case #PB_Shortcut_Down  :   keySetDown(key\backward)
                  Case #PB_Shortcut_Left  :   keyLeft = #True
                  Case #PB_Shortcut_Right :   keyRight = #True
                  Case #PB_Shortcut_A     :   keyUp = #True
                  Case #PB_Shortcut_Y     :   keyDown = #True
                EndSelect
              Case #PB_EventType_KeyUp
                ; pb bug: http://www.purebasic.fr/english/viewtopic.php?f=23&t=56366
                ; -32 to convert to uppercase, i.e returned 'e' (101) to 'E' (69), only neccessary for keyup, and only for letters (i.e. not for left, right etc.)
                ; using #PB_EventType_Input and Chr(GetGadgetAttribute(canvas, #PB_Canvas_Input)) is not an
                ; option since we need an keyup event to update our pressed/released key states
                app\tmpKeyUpShortcut = GetGadgetAttribute(app\canvas, #PB_Canvas_Key)
                If app\tmpKeyUpShortcut >= 97 And app\tmpKeyUpShortcut <= 122
                  app\tmpKeyUpShortcut - 32
                EndIf
                Select app\tmpKeyUpShortcut
                  Case #PB_Shortcut_Up    :   keySetUp(key\forward)
                  Case #PB_Shortcut_Down  :   keySetUp(key\backward)
                  Case #PB_Shortcut_Left  :   keyLeft = #False
                  Case #PB_Shortcut_Right :   keyRight = #False
                  Case #PB_Shortcut_A     :   keyUp = #False
                  Case #PB_Shortcut_Y     :   keyDown = #False
                EndSelect
              ;Case #PB_EventType_Input
              ;  Select Chr(GetGadgetAttribute(canvas, #PB_Canvas_Input))
              ;    Case "c" : Debug "klein c"
              ;    Case "C" : Debug "gross C"
              ;  EndSelect
            EndSelect
          EndIf
      EndSelect
    Until Not app\event
  EndIf
  ;}
  
  If app\init
    
    ;{ init-sequence
    If app\initTimer > ElapsedMilliseconds()
      Define f.f
      f = (1-((app\initTimer - ElapsedMilliseconds()) / app\initTime))
      app\zoom = app\zoomInitEnd * Pow(f, app\zoomInitEnd)
    Else
      app\zoom = app\zoomInitEnd
      app\init = #False
    EndIf
    ;}
    
  Else
    
    updatePlayer()
    processEnemies()
    moveObjects()
    updateCam(app\cam, app\player\ship\pos, app\player\ship\speed)
    
  EndIf ; [end init else]
  
; While addShots > 0
;   addShot(app\player\ship)
;   addShots - 1
; Wend
  
  If app\mouseButtonLeft And app\player\ship\timerNewShot < ElapsedMilliseconds()
    app\player\ship\timerNewShot = ElapsedMilliseconds() + app\timePlayerNewShot
    addShot(app\player\ship)
  EndIf
  
  sortObjects()
  updateObjectsStartEnd()
  
  checkCollisions()
  
  deleteObjects()
  
  setObjectPositions()    ; get 2d render positions
  setDrawingOperations()  ; setup list of drawing operations
  
  If Not #threaded
    draw( @ app)
  EndIf
  
Until app\quit

If #threaded
  exitDrawThread = #True
  ; last call to setDrawingOperations() in the main loop has signaled semaphoreDraw but
  ; it could have been consumed already by the thread (reproducible with a Delay()).
  While Not WaitThread(app\thread, 50)
    SignalSemaphore(semaphoreDraw)
  Wend
EndIf

;CloseScreen()
;CloseWindow(app\win)
; IDE Options = PureBasic 5.70 LTS beta 2 (Linux - x64)
; CursorPosition = 603
; FirstLine = 569
; Folding = ---
; Markers = 174,565,598
; EnableXP