﻿
Procedure.f min(a.f, b.f)
  If a < b
    ProcedureReturn a
  EndIf
  ProcedureReturn b
EndProcedure

Procedure.f max(a.f, b.f)
  If a > b
    ProcedureReturn a
  EndIf
  ProcedureReturn b
EndProcedure

Procedure.f PowSigned(number.f, exponent.f)
  If number < 0
    ProcedureReturn -Pow(-number, exponent)
  EndIf
  ProcedureReturn Pow(number, exponent)
EndProcedure

Procedure.f easeInOut(x.f)
  If x < 0.5
    ; [0 .. 0.5] --> [0 .. 1]
    x * 2.0
    ProcedureReturn 0.5 * ((x) * Pow(x, 2))
  Else
    ; [0.5 .. 1.0] --> [0 .. 1]
    x = (x - 0.5) * 2.0
    ; 1-x    = flip left/right
    ; 1 - .. = flip top/bottom
    ProcedureReturn 0.5 + 0.5 * (1 - (1-x) * Pow(1-x, 2))
  EndIf
EndProcedure

; IDE Options = PureBasic 5.70 beta 1 (Linux - x64)
; CursorPosition = 11
; Folding = -
; EnableXP