﻿
XIncludeFile "vec.h.pbi"
XIncludeFile "rotation.h.pbi"
XIncludeFile "transition.h.pbi"


EnumerationBinary
  #property_isBullet
  #property_isShootable  ; collidable might be better
  #property_isMovable
  #property_isEnemy
  #property_isDebris
EndEnumeration

Enumeration
  #previous_ignore
  #previous_update
  #previous_reset
EndEnumeration


Structure sFace
  List nodes.sVec3()
EndStructure

Structure sBoxCollider
  active.i
  
  ;                      .
  ;      0________1      .
  ;      /|       /|     .
  ;    3/_|_____2/ |     .
  ;    |  |     |  |     .
  ;    | 4|_____|_5|     .
  ;    | /      | /      .
  ;    |/_______|/       .
  ;    7         6       .
  ;                      .
  p.sVec3[8]
  
  minSize.f ; size of the smallest dimension (i.e. w if w < h and w < d)
  maxSize.f ; size of the largest dimension (i.e. w if w > h and w > d)
  
  *debugBox.sObject ; additional box object to show/debug collider on screen
  
EndStructure

Structure sObject
  properties.i
  
  pos.sVec3
  posPrevious.sVec3
  ;movedYMin.f
  ;movedYMax.f
  travelledSpaceMin.sVec3
  travelledSpaceMax.sVec3
  
  rotate.i ; bool
  rot.sRot3
  rotPrevious.sRot3
  rotTransitionZ.sTransition
  rotTransitionX.sTransition
  
  speed.sVec3
  
  List faces.sFace()
  colorLines.i
  colorFaces.i
  fade.f       ; fade by distance
  fadeDebris.f ; debris fade
  
  boxCollider.sBoxCollider
  
  *parentObject.sObject
  
  ; target of this
  targetPos.sVec3
  *targetObject.sObject
  ; targeted by player
  targeted.i ; bool
  
  timerNewShot.q
  timerAiNewTarget.q
  timerAiKeepTarget.q
  
  health.f
  
  deleteLater.i ; bool  
  
EndStructure
; IDE Options = PureBasic 5.70 LTS beta 2 (Linux - x64)
; CursorPosition = 41
; FirstLine = 15
; Folding = -
; EnableXP