﻿
XIncludeFile "object.h.pbi"

XIncludeFile "assert.pbi"
XIncludeFile "math.pbi"
XIncludeFile "vec.pbi"
XIncludeFile "app.h.pbi"
; XIncludeFile "transition.pbi"
XIncludeFile "rotation.pbi"
; XIncludeFile "cam.pbi"






Declare.i createBox(x.f, y.f, z.f, xSize.f, ySize.f, zSize.f, colorLines, colorFaces, properties)
Declare   setPos(*object.sObject, x.f, y.f, z.f, previous = #previous_update)
Declare   updateTravelledSpace(*obj.sObject)




Procedure setBoxColliderDimensions(*boxCollider.sBoxCollider,  x1.f, x2.f,  y1.f, y2.f,  z1.f, z2.f)
  
  ; ensure 1 < 2
  If x1 > x2
    Swap x1, x2
  EndIf
  If y1 > y2
    Swap y1, y2
  EndIf
  If z1 > z2
    Swap z1, z2
  EndIf
  
  ; store metrix
  vecSet(*boxCollider\p[0], x1, y2, z2)
  vecSet(*boxCollider\p[1], x2, y2, z2)
  vecSet(*boxCollider\p[2], x2, y1, z2)
  vecSet(*boxCollider\p[3], x1, y1, z2)
  vecSet(*boxCollider\p[4], x1, y2, z1)
  vecSet(*boxCollider\p[5], x2, y2, z1)
  vecSet(*boxCollider\p[6], x2, y1, z1)
  vecSet(*boxCollider\p[7], x1, y1, z1)
  
  ; get smallest dimension (for collision test interpolation step)
  *boxCollider\minSize = min(              (x2 - x1), (y2 - y1) )
  *boxCollider\minSize = min( (*boxCollider\minSize), (z2 - z1) )
  
  ; get largest dimension (for travelled space calculation used in collision pre-test)
  *boxCollider\maxSize = max(              (x2 - x1), (y2 - y1) )
  *boxCollider\maxSize = max( (*boxCollider\maxSize), (z2 - z1) )
  
EndProcedure

Procedure setBoxCollider(*object.sObject,  x1.f, x2.f,  y1.f, y2.f,  z1.f, z2.f)
  ;Shared debugColliders
  Define colorLines, colorFaces, properties
  
  *object\boxCollider\active = #True
  
  setBoxColliderDimensions(*object\boxCollider,  x1, x2,  y1, y2,  z1, z2)
  ; update travelledSpace with updated collider minSize/maxSize
  updateTravelledSpace(*object)
  
  ; add box to show/debug boxCollider
  If app\debugColliders
    colorLines = $ffccccff
    colorFaces = $00000000
    properties = 0
    ; visible debug box object.
    ; 1 unit larger than the object and the boxcollider.
    ; currently not updated if setBoxYSize() and setBoxColliderDimensions() is called
    *object\boxCollider\debugBox = createBox( (*object\pos\x), (*object\pos\y), (*object\pos\z),  
                                              (x2 - x1 + 1), (y2 - y1 + 1), (z2 - z1 + 1),  
                                              colorLines, colorFaces, properties)
    *object\boxCollider\debugBox\parentObject = *object
    *object\boxCollider\debugBox\rotate = #True
  EndIf  
  
EndProcedure

Procedure addNodeByPos(List nodes.sVec3(), x.f, y.f, z.f)
  AddElement(nodes())
  nodes()\x = x
  nodes()\y = y
  nodes()\z = z
EndProcedure

Procedure addNodeByVec(List nodes.sVec3(), *v.sVec3)
  AddElement(nodes())
  nodes()\x = *v\x
  nodes()\y = *v\y
  nodes()\z = *v\z
EndProcedure

Procedure addFace(List faces.sFace())
  AddElement(faces())
EndProcedure

Procedure addFaceByVecs(List faces.sFace(), *v1.sVec3, *v2.sVec3, *v3.sVec3, *v4.sVec3 = #Null, *v5.sVec3 = #Null)
  AddElement(faces())
  ; a face has..
  ; ..triangle: 3 vertices + 1 optional closing vertex ( = 3 or 4 vertices)
  ; ..quad    : 4 vertices + 1 optional closing vertex ( = 4 or 5 vertices)
  addNodeByVec(faces()\nodes(), *v1)
  addNodeByVec(faces()\nodes(), *v2)
  addNodeByVec(faces()\nodes(), *v3)
  If *v4
    addNodeByVec(faces()\nodes(), *v4)
  EndIf
  If *v5
    addNodeByVec(faces()\nodes(), *v5)
  EndIf
EndProcedure

Procedure.i createObject(x.f, y.f, z.f, colorLines, colorFaces, properties)
  ;Shared objects()
  Protected *object.sObject
  
  PushListPosition(app\objects())
  AddElement(app\objects())
  *object = app\objects()
  PopListPosition(app\objects())
  
  *object\properties = properties
  *object\health = 100.0
  
  If properties & #property_isMovable
    setPos(*object, x, y, z, #previous_reset)
  Else
    setPos(*object, x, y, z, #previous_ignore)
  EndIf
  updateTravelledSpace(*object)
  
  *object\colorLines = colorLines
  *object\colorFaces = colorFaces
  
  ProcedureReturn *object
EndProcedure  

Procedure.i createBox(x.f, y.f, z.f, xSize.f, ySize.f, zSize.f, colorLines, colorFaces, properties)
  Protected *object.sObject
  
  *object = createObject(x, y, z, colorLines, colorFaces, properties)
  
  ; (still true?)
  ; y positions of nodes should all be zero or negative (relative to object position), otherwise
  ; these node positions become mirrored in the x/y plane if object is near far plane and the
  ; nodes are beyond far plane.
  
  addFace(*object\faces()) ; rear
  addNodeByPos(*object\faces()\nodes(), -xSize/2, -ySize,  zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2, -ySize,  zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2, -ySize, -zSize/2)
  addNodeByPos(*object\faces()\nodes(), -xSize/2, -ySize, -zSize/2)
  addNodeByPos(*object\faces()\nodes(), -xSize/2, -ySize,  zSize/2)
  
  addFace(*object\faces()) ; left
  addNodeByPos(*object\faces()\nodes(), -xSize/2, -ySize,  zSize/2)
  addNodeByPos(*object\faces()\nodes(), -xSize/2,      0,  zSize/2)
  addNodeByPos(*object\faces()\nodes(), -xSize/2,      0, -zSize/2)
  addNodeByPos(*object\faces()\nodes(), -xSize/2, -ySize, -zSize/2)
  
  addFace(*object\faces()) ; right
  addNodeByPos(*object\faces()\nodes(),  xSize/2, -ySize,  zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2,      0,  zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2,      0, -zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2, -ySize, -zSize/2)
  
  addFace(*object\faces()) ; top
  addNodeByPos(*object\faces()\nodes(), -xSize/2, -ySize,  zSize/2)
  addNodeByPos(*object\faces()\nodes(), -xSize/2,      0,  zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2,      0,  zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2, -ySize,  zSize/2)
  
  addFace(*object\faces()) ; bottom
  addNodeByPos(*object\faces()\nodes(), -xSize/2, -ySize, -zSize/2)
  addNodeByPos(*object\faces()\nodes(), -xSize/2,      0, -zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2,      0, -zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2, -ySize, -zSize/2)
  
  addFace(*object\faces()) ; front
  addNodeByPos(*object\faces()\nodes(), -xSize/2,      0,  zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2,      0,  zSize/2)
  addNodeByPos(*object\faces()\nodes(),  xSize/2,      0, -zSize/2)
  addNodeByPos(*object\faces()\nodes(), -xSize/2,      0, -zSize/2)
  
  ProcedureReturn *object
EndProcedure

Procedure setBoxYSize(*object.sObject, ySize.f)
  Static fi.i
  Static ni.i
  
  Assert(ListSize(*object\faces()) = 6)
  ForEach *object\faces()
    ;Assert(ListSize(*object\faces()\nodes()) = 4)
    fi = ListIndex(*object\faces())
    ForEach *object\faces()\nodes()
      ni = ListIndex(*object\faces()\nodes())
      ; face 1 node 1-4 ; face 2,3,4,5 node 1 and 4 ; face 6 none
      If (fi = 0) Or ((ni = 0 Or ni = 3) And (fi <> 5))
        *object\faces()\nodes()\y = ySize
      EndIf
    Next
  Next
  
  If *object\boxCollider\active
    ; update box collider
    ; won't update collider debug box but will update collider minSize/maxSize.
    ; note that minSize of player sight will mostly stay '2' which is its height and thus its MINsize)
    setBoxColliderDimensions(*object\boxCollider, 
                             *object\boxCollider\p[0]\x,
                             *object\boxCollider\p[1]\x,
                             *object\boxCollider\p[3]\y,
                             ySize, ;*object\boxCollider\p[4]\y,
                             *object\boxCollider\p[7]\z,
                             *object\boxCollider\p[0]\z)
  EndIf
EndProcedure

Procedure.i createBoxCollidable(x.f, y.f, z.f, xSize.f, ySize.f, zSize.f, colorLines, colorFaces, properties)
  Protected *object.sObject
  *object = createBox(x, y, z, xSize, ySize, zSize, colorLines, colorFaces, properties)
  
  setBoxCollider(*object,  -xSize/2, xSize/2,  0, -ySize,  -zSize/2, zSize/2)
  
  ProcedureReturn *object
EndProcedure

Procedure.i createShip(x.f, y.f, z.f, xSize.f, ySize.f, zSize.f, colorLines, colorFaces, properties)
;   Shared debugColliders
  Protected *object.sObject
  
  *object = createObject(x, y, z, colorLines, colorFaces, properties)
  
  setBoxCollider(*object,  -xSize/2, xSize/2,  -ySize, 0,  -zSize/2, zSize/2)
  
  *object\rotate = #True
  
  Define left   = -xSize / 2
  Define right  =  xSize / 2
  
  Define top    =  zSize / 2
  Define bottom = -zSize / 2
  
  Define nose   =  0.0
  Define back   =  -ySize
  
  Dim v.sVec3(10, 10)
  
  ; nose face
  vecSet( v(1, 1),  (left  * 0.25),  (back * 0.0),  (top    * 0.5) )
  vecSet( v(1, 2),  (right * 0.25),  (back * 0.0),  (top    * 0.5) )
  vecSet( v(1, 3),  (right * 0.25),  (back * 0.0),  (bottom * 0.5) )
  vecSet( v(1, 4),  (left  * 0.25),  (back * 0.0),  (bottom * 0.5) )
  
  ; 2. plane
  vecSet( v(2, 1),  (left  * 0.5),  (back * 0.5),  (top    * 1.0) )
  vecSet( v(2, 2),  (right * 0.5),  (back * 0.5),  (top    * 1.0) )
  vecSet( v(2, 3),  (right * 0.5),  (back * 0.5),  (bottom * 1.0) )
  vecSet( v(2, 4),  (left  * 0.5),  (back * 0.5),  (bottom * 1.0) )
  
  ; 3. plane
  vecSet( v(3, 1),  (left  * 0.9),  (back * 0.7),  (top    * 0.5) )
  vecSet( v(3, 2),  (right * 0.9),  (back * 0.7),  (top    * 0.5) )
  vecSet( v(3, 3),  (right * 0.9),  (back * 0.7),  (bottom * 0.5) )
  vecSet( v(3, 4),  (left  * 0.9),  (back * 0.7),  (bottom * 0.5) )
  
  ; 4. plane
  vecSet( v(4, 1),  (left  * 1.0),  (back * 0.9),  (top    * 0.5) )
  vecSet( v(4, 2),  (right * 1.0),  (back * 0.9),  (top    * 0.5) )
  vecSet( v(4, 3),  (right * 1.0),  (back * 0.9),  (bottom * 0.5) )
  vecSet( v(4, 4),  (left  * 1.0),  (back * 0.9),  (bottom * 0.5) )
  
  ; 5. plane
  vecSet( v(5, 1),  (left  * 0.5),  (back * 1.0),  (top    * 1.0) )
  vecSet( v(5, 2),  (right * 0.5),  (back * 1.0),  (top    * 1.0) )
  vecSet( v(5, 3),  (right * 0.5),  (back * 1.0),  (bottom * 1.0) )
  vecSet( v(5, 4),  (left  * 0.5),  (back * 1.0),  (bottom * 1.0) )
  
  ; front face (nose)
  addFaceByVecs(*object\faces(),  v(1, 1), v(1, 2), v(1, 3), v(1, 4), v(1, 1)) ; front                              ----------                 v(1, ) |
  ;                                                                                                                                                   |
  ; nose sides                                                                                                    ______________               v(1, ) |
  addFaceByVecs(*object\faces(),  v(1, 1), v(2, 1), v(2, 4), v(1, 4), v(1, 1)) ; left                            /              \                     |
  addFaceByVecs(*object\faces(),  v(1, 1), v(1, 2), v(2, 2), v(2, 1), v(1, 1)) ; top                            /                \                    |
  addFaceByVecs(*object\faces(),  v(1, 2), v(2, 2), v(2, 3), v(1, 3), v(1, 2)) ; right                         /                  \                   |
  addFaceByVecs(*object\faces(),  v(1, 4), v(1, 3), v(2, 3), v(2, 4), v(1, 4)) ; bottom                       /____________________\           v(2, ) |
  ;                                                                                                                                                   |
  ; wing fronts;                                                                                                                                      |
  addFaceByVecs(*object\faces(),  v(2, 1), v(3, 1), v(3, 4), v(2, 4), v(2, 1)) ; front left               _-                          -_       v(2, ) |
  addFaceByVecs(*object\faces(),  v(2, 2), v(3, 2), v(3, 3), v(2, 3), v(2, 2)) ; front right            _-                              -_     v(3, ) |
  ;                                                                                                                                                   |
  ; wings/body                                                                                               ________________________          v(2, ) |
  addFaceByVecs(*object\faces(),  v(3, 1), v(4, 1), v(4, 4), v(3, 4), v(3, 1)) ; left                     _-|                        |-_              |
  addFaceByVecs(*object\faces(),  v(3, 1), v(2, 1), v(5, 1), v(4, 1), v(3, 1)) ; top left               _-  |                        |  -_     v(3, ) |
  addFaceByVecs(*object\faces(),  v(2, 1), v(2, 2), v(5, 2), v(5, 1), v(2, 1)) ; top                   |    |                        |    |           |
  addFaceByVecs(*object\faces(),  v(2, 2), v(5, 2), v(4, 2), v(3, 2), v(2, 2)) ; top right             |    |                        |    |           |
  addFaceByVecs(*object\faces(),  v(3, 2), v(4, 2), v(4, 3), v(3, 3), v(3, 2)) ; right                 |    |                        |    |    v(4, ) |
  addFaceByVecs(*object\faces(),  v(2, 3), v(5, 3), v(4, 3), v(3, 3), v(2, 3)) ; bottom right           -_  |                        |  _-            |
  addFaceByVecs(*object\faces(),  v(2, 4), v(2, 3), v(5, 3), v(5, 4), v(2, 4)) ; bottom                   -_|                        |_-              |
  addFaceByVecs(*object\faces(),  v(3, 4), v(4, 4), v(5, 4), v(2, 4), v(3, 4)) ; bottom left                -________________________-         v(5, ) |
  ;                                                                                                                                                   |
  ; wing backs;                                                                                                                                       |
  addFaceByVecs(*object\faces(),  v(4, 1), v(5, 1), v(5, 4), v(4, 4), v(4, 1)) ; back left              -_                              _-     v(4, ) |
  addFaceByVecs(*object\faces(),  v(5, 2), v(4, 2), v(4, 3), v(5, 3), v(5, 2)) ; back right               -_                          _-       v(5, ) |
  ;                                                                                                                                                   |
  ; back;                                                                                                                                             |
  addFaceByVecs(*object\faces(),  v(5, 1), v(5, 2), v(5, 3), v(5, 4), v(5, 1)) ; back                        ------------------------          v(5, ) |
  
  ProcedureReturn *object
EndProcedure













Procedure updateTravelledSpace(*obj.sObject)
  
  ; not sure if this is right for player sight. 
  ; tried to reduce 'backward' space for player sight by not applying maxSize backwards / behind player, though collisions there
  ; would be skipped anyway by range of object list start/end.
  ; also sight size will make travelled space large for x and z too which is mostly redundant but not always.
  
  ;maybe also
  ;if collidable
  
  If *obj = app\player\sight
    *obj\travelledSpaceMin\x = min(*obj\posPrevious\x, *obj\pos\x)
    *obj\travelledSpaceMin\y = min(*obj\posPrevious\y, *obj\pos\y)
    *obj\travelledSpaceMin\z = min(*obj\posPrevious\z, *obj\pos\z)
    *obj\travelledSpaceMax\x = max(*obj\posPrevious\x, *obj\pos\x) + (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMax\y = max(*obj\posPrevious\y, *obj\pos\y) + (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMax\z = max(*obj\posPrevious\z, *obj\pos\z) + (*obj\boxCollider\maxSize)
  ElseIf *obj\properties & #property_isMovable
    *obj\travelledSpaceMin\x = min(*obj\posPrevious\x, *obj\pos\x) - (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMin\y = min(*obj\posPrevious\y, *obj\pos\y) - (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMin\z = min(*obj\posPrevious\z, *obj\pos\z) - (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMax\x = max(*obj\posPrevious\x, *obj\pos\x) + (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMax\y = max(*obj\posPrevious\y, *obj\pos\y) + (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMax\z = max(*obj\posPrevious\z, *obj\pos\z) + (*obj\boxCollider\maxSize)
  Else
    *obj\travelledSpaceMin\x = *obj\pos\x - (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMin\y = *obj\pos\y - (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMin\z = *obj\pos\z - (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMax\x = *obj\pos\x + (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMax\y = *obj\pos\y + (*obj\boxCollider\maxSize)
    *obj\travelledSpaceMax\z = *obj\pos\z + (*obj\boxCollider\maxSize)
  EndIf
  
EndProcedure

Procedure setPos(*object.sObject, x.f, y.f, z.f, previous = #previous_update)
  If *object\properties & #property_isMovable
    Select previous
      Case #previous_reset
        ; reset previous to new position
        *object\posPrevious\x = x
        *object\posPrevious\y = y
        *object\posPrevious\z = z
      Case #previous_update
        ; update previous to old position
        *object\posPrevious = *object\pos
    EndSelect
  Else
    assert(previous = #previous_ignore)
    ; a quick fix:
    ; immovable objects still need posPrevious to be reset to pos at least once since
    ; collision test now also interpolates over obj2 travelled space.
    ; updateTravelledSpace() (and pre-collision test) also make use of this.
    ; ...
    ; update:
    ; !!! not true: coll test does only interpolate over isMovable!
    ; (and it didn't solve the false sight/scyscraper collision!)
    ; but added immovable branch in updateTravelledSpace()
;     *object\posPrevious\x = x
;     *object\posPrevious\y = y
;     *object\posPrevious\z = z
  EndIf
  ; update position
  *object\pos\x = x
  *object\pos\y = y
  *object\pos\z = z
EndProcedure

Procedure setPosByVec(*object.sObject, *newPos.sVec3, previous = #previous_update)
  setPos(*object, *newPos\x, *newPos\y, *newPos\z, previous)
EndProcedure

Procedure setRot(*object.sObject, ax.f, ay.f, az.f, previous = #previous_update)
  If *object\properties & #property_isMovable
    Select previous
      Case #previous_reset
        ; reset previous to new rotation
        *object\rotPrevious\ax = ax
        *object\rotPrevious\ay = ay
        *object\rotPrevious\az = az
      Case #previous_update
        ; update previous to old rotation
        *object\rotPrevious = *object\rot
    EndSelect
  Else
    assert(previous = #previous_ignore)
  EndIf
  ; update rotation
  *object\rot\ax = ax
  *object\rot\ay = ay
  *object\rot\az = az
EndProcedure

Procedure setRotByVec(*object.sObject, *newRot.sRot3, previous = #previous_update)
  setRot(*object, *newRot\ax, *newRot\ay, *newRot\az, previous)
EndProcedure

Procedure updateDebugBox(*object.sObject, updatePosition, updateRotation)
;   Shared debugColliders
  
  ; updates only debugBox of collider, not the collider itself (collider has no own position or rotation)
  
  If app\debugColliders And *object\boxCollider\debugBox
    If updatePosition
      setPosByVec(*object\boxCollider\debugBox, *object\pos, #previous_ignore)
      updateTravelledSpace(*object\boxCollider\debugBox)
    EndIf
    If updateRotation
      setRotByVec(*object\boxCollider\debugBox, *object\rot, #previous_ignore)
    EndIf
  EndIf
EndProcedure

Procedure destroyObject(*object.sObject)
  Protected *newSingleFaceObject.sObject
  Protected facePos.sVec3
  Protected dx.f, dy.f, dz.f
  Protected objSpeed.sVec3
  Protected faceSpeed.sVec3
  Protected colorLines
  Protected colorFaces
  ; Protected gray
  Protected *firstNode.sVec3
  Protected *lastNode.sVec3
  
  ForEach *object\faces()
    
    ; create new object for each face
    ForEach *object\faces()\nodes()
      
      colorLines = *object\colorLines
      ;gray = (Red(colorLines) + Green(colorLines) + Blue(colorLines)) / 3
      ;colorLines = RGBA(gray, gray, gray, Alpha(colorLines))
      ;
      colorFaces = *object\colorFaces
      ;gray = (Red(colorFaces) + Green(colorFaces) + Blue(colorFaces)) / 3
      ;colorFaces = RGBA(gray, gray, gray, Alpha(colorFaces))
      
      *newSingleFaceObject = createObject(*object\pos\x, ; (will be repositioned)
                                          *object\pos\y, 
                                          *object\pos\z, 
                                          colorLines, 
                                          colorFaces, 
                                          #property_isMovable | #property_isDebris)
      
      addFace(*newSingleFaceObject\faces())
      ForEach *object\faces()\nodes()
        
        ; get rotated node position
        rotate(*object\faces()\nodes()\x, 
               *object\faces()\nodes()\y, 
               *object\faces()\nodes()\z,  
               *object\rot\ax, 
               *object\rot\ay, 
               *object\rot\az, 
               @ dx, @ dy, @ dz)
        
        addNodeByPos(*newSingleFaceObject\faces()\nodes(), 
                     dx, 
                     dy, 
                     dz)
      Next
      
      ; add closing node for face if neccessary
      *firstNode = FirstElement(*newSingleFaceObject\faces()\nodes())
      *lastNode = LastElement(*newSingleFaceObject\faces()\nodes())
      If *firstNode And *lastNode
        If (*firstNode\x = *lastNode\x) And (*firstNode\y = *lastNode\y) And (*firstNode\z = *lastNode\z)
        Else
          addNodeByVec(*newSingleFaceObject\faces()\nodes(), *firstNode)
        EndIf
      EndIf
      
      ; get face position (nodes mean position)
      vecSet( @ facePos, 0, 0, 0)
      ForEach *newSingleFaceObject\faces()\nodes()
        vecAdd( @ facePos, @ *newSingleFaceObject\faces()\nodes())
      Next
      facePos\x / ListSize(*newSingleFaceObject\faces()\nodes())
      facePos\y / ListSize(*newSingleFaceObject\faces()\nodes())
      facePos\z / ListSize(*newSingleFaceObject\faces()\nodes())
      
      ; substract face position from nodes
      ForEach *newSingleFaceObject\faces()\nodes()
        vecMinus( @ *newSingleFaceObject\faces()\nodes(), @ facePos,  @ *newSingleFaceObject\faces()\nodes())
      Next
      
      ; add face position to object
      setPos(*newSingleFaceObject, 
             *newSingleFaceObject\pos\x + facePos\x, 
             *newSingleFaceObject\pos\y + facePos\y, 
             *newSingleFaceObject\pos\z + facePos\z, 
             #previous_reset)
      updateTravelledSpace(*newSingleFaceObject)
      
      ; (actually relative face pos direction (including object rotation) should become newObject rotation, and speed should be just +y)
      
      ; get and add rotated object speed vector
      rotate(*object\speed\x, *object\speed\y, *object\speed\z,  *object\rot\ax, *object\rot\ay, *object\rot\az,  @ objSpeed\x, @ objSpeed\y, @ objSpeed\z)
      *newSingleFaceObject\speed = objSpeed
      
      ; use relative face pos direction as additional speed vector
      faceSpeed = facePos
      vecNormalizeMagnitude( @ faceSpeed)
      faceSpeed\x * (100.0 + 0*Random(130))
      faceSpeed\y * (100.0 + 0*Random(130))
      faceSpeed\z * (100.0 + 0*Random(130))
      vecAdd( @ *newSingleFaceObject\speed, @ faceSpeed)
      
      
;       setRot(*newSingleFaceObject, 
;              normalizeAngle(Radian(-10 + Random(20))), 
;              normalizeAngle(Radian(-10 + Random(20))), 
;              normalizeAngle(Radian(-10 + Random(20))), 
;              #previous_reset)
      
      *newSingleFaceObject\fadeDebris = 1.0
      
    Next
    
  Next
EndProcedure

Procedure deleteObjectLater(*object.sObject)
;   Shared *deletedObjects()
;   Shared objects()
  
  ; allow interpolated collision detection to work first on the
  ; distance travelled so far during this frame, delete object later
  
  ;Static found
  ;found = #False
  ;ForEach app\deletedObjects()
  ;  If app\deletedObjects() = *object
  ;    found = #True
  ;    Break
  ;  EndIf
  ;Next
  ;If Not found
  If Not *object\deleteLater
    AddElement(app\deletedObjects())
    ;app\deletedObjects() = app\objects()
    app\deletedObjects() = *object
    *object\deleteLater = #True
  EndIf
  
EndProcedure

Procedure deleteObject(*object.sObject)
;   Shared objects(), *objectsStart, *objectsEnd, debugColliders
  
  If app\debugColliders And *object\boxCollider\debugBox
    deleteObject(*object\boxCollider\debugBox)
  EndIf
  
  ;Assert(*object <> app\objects()) ; not sure if neccessary
  
  ;PushListPosition(app\objects())
  ChangeCurrentElement(app\objects(), *object)
  
  If app\objects() = app\objectsStart
    If NextElement(app\objects()) ; that's correct: shrink start inwards, forward in list, next visible object
      app\objectsStart = app\objects()
    Else
      app\objectsStart = #Null
      Assert(0)
    EndIf
  EndIf
  If app\objects() = app\objectsEnd
    If PreviousElement(app\objects()) ; that's correct: shrink end inwards, back in list, previous visible object
      app\objectsEnd = app\objects()
    Else
      app\objectsEnd = #Null
      Assert(0)
    EndIf
  EndIf
  
  ChangeCurrentElement(app\objects(), *object)
  ;If app\objects()\parentObject
  ;  app\objects()\parentObject\boxCollider\debugBox = #Null
  ;EndIf
  DeleteElement(app\objects())
  
  ;PopListPosition(app\objects())
  
EndProcedure

Procedure deleteObjects()
;   Shared *deletedObjects(), objects()
  
  ; clear backreferences
  ForEach app\objects()
    ForEach app\deletedObjects()
      If app\deletedObjects() = app\objects()\boxCollider\debugBox
        app\objects()\boxCollider\debugBox = #Null
      EndIf
      If app\deletedObjects() = app\objects()\targetObject
        app\objects()\targetObject = #Null
      EndIf
      If app\deletedObjects() = app\objects()\parentObject
        app\objects()\parentObject = #Null
      EndIf
    Next
  Next
  
  ForEach app\deletedObjects()
    ; is currently function static, not a player member field yet. (todo)
    ;If *sightTargetPrevious
    ;  *sightTargetPrevious\targeted = #True
    ;EndIf
    deleteObject(app\deletedObjects())
  Next
  ClearList(app\deletedObjects())
  
EndProcedure












Procedure.i boxCollision(*boxCollider1.sBoxCollider, *pos1.sVec3, ax1.f, ay1.f, az1.f, 
                         *boxCollider2.sBoxCollider, *pos2.sVec3, ax2.f, ay2.f, az2.f)
  If *boxCollider1\active And *boxCollider2\active
    
    Static Dim box1.sVec3(7)
    Static Dim box2.sVec3(7)
    Static ii
    For ii = 0 To 7
      vecSetByVec( @ box1(ii),  *boxCollider1\p[ii] )
      vecSetByVec( @ box2(ii),  *boxCollider2\p[ii] )
      rotate( box1(ii)\x, box1(ii)\y, box1(ii)\z,  ax1, ay1, az1,  @ box1(ii)\x, @ box1(ii)\y, @ box1(ii)\z)
      rotate( box2(ii)\x, box2(ii)\y, box2(ii)\z,  ax2, ay2, az2,  @ box2(ii)\x, @ box2(ii)\y, @ box2(ii)\z)
      vecAdd( @ box1(ii),  *pos1 )
      vecAdd( @ box2(ii),  *pos2 )
    Next
    
;     If app\deb
;       app\deb = #False
;       Static done
;       If Not done
;         ;done = #True
;         Protected _i
; ;         Debug "-----  1 x " : For _i=0 To 7 : Debug "  " + StrF(box1(_i)\x, 0) : Next
; ;         Debug "-----  1 y " : For _i=0 To 7 : Debug "  " + StrF(box1(_i)\y, 0) : Next
; ;         Debug "-----  1 z " : For _i=0 To 7 : Debug "  " + StrF(box1(_i)\z, 0) : Next
; ;         Debug "-----  2 x " : For _i=0 To 7 : Debug "  " + StrF(box2(_i)\x, 0) : Next
; ;         Debug "-----  2 y " : For _i=0 To 7 : Debug "  " + StrF(box2(_i)\y, 0) : Next
; ;         Debug "-----  2 z " : For _i=0 To 7 : Debug "  " + StrF(box2(_i)\z, 0) : Next
;         ;ClearList(debVec())
;         For _i=0 To 7
;           AddElement(debVec()) : debVec() = box1(_i)
;         Next
;         For _i=0 To 7
;           AddElement(debVec()) : debVec() = box2(_i)
;         Next
;         ForEach debVec()
;           ;Debug "debVec x " + StrF(debVec()\, 0)
;         Next
;       EndIf
; ;       Debug "box1(0)" + "x:" + StrF(box1(0)\x, 0)  + "y:" + StrF(box1(0)\y, 0)  + "z:" + StrF(box1(0)\z, 0) 
;       ;CallDebugger
;     EndIf
    
    Static countIntersection
    Static i, iNormal
    
    countIntersection = 0
    
    For iNormal = 1 To 15
      
      Static.sVec3 *edge1start
      Static.sVec3 *edge1end
      Static.sVec3 *edge2start
      Static.sVec3 *edge2end
      Static.sVec3 normal
      Static.sVec3 edge1Direction
      Static.sVec3 edge2Direction
      Static.sVec3 normalOrigin
      
      Select iNormal
          
          ; box1 edge pairs (3 faces/normals)
        Case 1   :   *edge1start = @ box1(0)   :   *edge1end = @ box1(3)   :   *edge2start = @ box1(0)   :   *edge2end = @ box1(1)
        Case 2   :   *edge1start = @ box1(0)   :   *edge1end = @ box1(1)   :   *edge2start = @ box1(0)   :   *edge2end = @ box1(4)
        Case 3   :   *edge1start = @ box1(0)   :   *edge1end = @ box1(4)   :   *edge2start = @ box1(0)   :   *edge2end = @ box1(3)
          
          ; box2 edge pairs (3 faces/normals)
        Case 4   :   *edge1start = @ box2(0)   :   *edge1end = @ box2(3)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(1)
        Case 5   :   *edge1start = @ box2(0)   :   *edge1end = @ box2(1)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(4)
        Case 6   :   *edge1start = @ box2(0)   :   *edge1end = @ box2(4)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(3)
          
          ; box1 edge 1-3 with box2 edge 1
        Case 7   :   *edge1start = @ box1(0)   :   *edge1end = @ box1(1)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(1)
        Case 8   :   *edge1start = @ box1(0)   :   *edge1end = @ box1(4)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(1)
        Case 9   :   *edge1start = @ box1(0)   :   *edge1end = @ box1(3)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(1)
          
          ; box1 edge 1-3 with box2 edge 2
        Case 10  :   *edge1start = @ box1(0)   :   *edge1end = @ box1(1)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(4)
        Case 11  :   *edge1start = @ box1(0)   :   *edge1end = @ box1(4)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(4)
        Case 12  :   *edge1start = @ box1(0)   :   *edge1end = @ box1(3)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(4)
          
          ; box1 edge 1-3 with box2 edge 3
        Case 13  :   *edge1start = @ box1(0)   :   *edge1end = @ box1(1)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(3)
        Case 14  :   *edge1start = @ box1(0)   :   *edge1end = @ box1(4)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(3)
        Case 15  :   *edge1start = @ box1(0)   :   *edge1end = @ box1(3)   :   *edge2start = @ box2(0)   :   *edge2end = @ box2(3)
          
      EndSelect
      
      ; edge-end minus edge-start = edge direction vector
      vecMinus(*edge1end, *edge1start, @ edge1Direction)
      vecMinus(*edge2end, *edge2start, @ edge2Direction)
      
      vecCrossProduct(edge1Direction, edge2Direction, @ normal)
      ;vecNormalizeMagnitude( @ normal)
      
      If iNormal <= 6
        ; align normal at face center
        normalOrigin\x = *edge1start\x + edge1Direction\x/2 + edge2Direction\x/2
        normalOrigin\y = *edge1start\y + edge1Direction\y/2 + edge2Direction\y/2
        normalOrigin\z = *edge1start\z + edge1Direction\z/2 + edge2Direction\z/2
      Else
        ; align normal between edges
        normalOrigin\x = (*edge1start\x + edge1Direction\x/2 + *edge2start\x + edge2Direction\x/2) / 2
        normalOrigin\y = (*edge1start\y + edge1Direction\y/2 + *edge2start\y + edge2Direction\y/2) / 2
        normalOrigin\z = (*edge1start\z + edge1Direction\z/2 + *edge2start\z + edge2Direction\z/2) / 2
      EndIf
      
      Static b
      Static.sVec3 p
      Static.f pProjected
      Static.f box1ProjectedMin
      Static.f box1ProjectedMax
      Static.f box2ProjectedMin
      Static.f box2ProjectedMax
      box1ProjectedMin = 99999999999
      box1ProjectedMax = -99999999999
      box2ProjectedMin = 99999999999
      box2ProjectedMax = -99999999999
      
      ; project all 8 corners of each of the 2 boxes onto the current normal to get a range per box
      For b = 1 To 2
        For i = 0 To 7
          Select b
            Case 1 :
              vecMinus(box1(i),  normalOrigin,  @ p)               ; get corner position realtive to normal origin
              pProjected = vecDotProduct( @ normal,  p)            ; get position on normal
              box1ProjectedMin = min(box1ProjectedMin, pProjected) ; update range
              box1ProjectedMax = max(box1ProjectedMax, pProjected)
            Case 2 :
              vecMinus(box2(i),  normalOrigin,  @ p)               ; get corner position realtive to normal origin
              pProjected = vecDotProduct( @ normal,  p)            ; get position on normal
              box2ProjectedMin = min(box2ProjectedMin, pProjected) ; update range
              box2ProjectedMax = max(box2ProjectedMax, pProjected)
          EndSelect
        Next
      Next
      
      If (box1ProjectedMax >= box2ProjectedMin) And (box1ProjectedMin <= box2ProjectedMax)
        
        countIntersection + 1
        
      Else
        
        ProcedureReturn #False
      EndIf
      
    Next
    
  EndIf
  
  ProcedureReturn Bool(countIntersection = 15)
EndProcedure

Procedure.i boxCollisionInterpolated(*obj1.sObject, *obj2.sObject)
  Static.f o1dx, o1dy, o1dz, o1dax, o1day, o1daz
  Static.f o2dx, o2dy, o2dz, o2dax, o2day, o2daz
  Static.f d
  Static.f stpNorm, f
  Static o1pos.sVec3, o1rot.sRot3
  Static o2pos.sVec3, o2rot.sRot3
  
  Static o1minSize.f
  Static o2minSize.f
  Static minSize.f
  
;   If *obj1 = app\player\sight
;     ProcedureReturn #False
;   EndIf
  
;   Debug "blaa " + Random(99)
  
  If *obj1\boxCollider\active And *obj2\boxCollider\active
    
    ; note: checkCollisions() already ensures that obj1 is always bullet and obj2 is never bullet
    assert( (*obj1\properties & #property_isMovable) Or (*obj1 = app\player\sight) )
    assert( (*obj1\properties & #property_isBullet) Or (*obj1 = app\player\sight) )
    
;     app\deb = #False
;     If (*obj1\properties & #property_isBullet) And (*obj2 = app\debObj1)
;       app\deb = #True
;     EndIf
;     
;     If app\deb
;     EndIf
;     
;     If app\deb
; ;       Debug "" + *obj1\pos\y + " // " + *obj1\posPrevious\y + " // " + *obj2\pos\y
;     EndIf
    
    ; obj1 delta pos/rot
    o1dx = *obj1\pos\x - *obj1\posPrevious\x
    o1dy = *obj1\pos\y - *obj1\posPrevious\y
    o1dz = *obj1\pos\z - *obj1\posPrevious\z
    o1dax = *obj1\rot\ax - *obj1\rotPrevious\ax
    o1day = *obj1\rot\ay - *obj1\rotPrevious\ay
    o1daz = *obj1\rot\az - *obj1\rotPrevious\az
    
;     If *obj1 = app\debObj1
;       Debug "#####"
;     EndIf
    
    ; obj2 delta pos/rot
    If *obj2\properties & #property_isMovable
      ; use delta, interpolate
      o2dx = *obj2\pos\x - *obj2\posPrevious\x
      o2dy = *obj2\pos\y - *obj2\posPrevious\y
      o2dz = *obj2\pos\z - *obj2\posPrevious\z
      o2dax = *obj2\rot\ax - *obj2\rotPrevious\ax
      o2day = *obj2\rot\ay - *obj2\rotPrevious\ay
      o2daz = *obj2\rot\az - *obj2\rotPrevious\az
    Else
      ; use fixed
      o2pos\x = *obj2\pos\x
      o2pos\y = *obj2\pos\y
      o2pos\z = *obj2\pos\z
      o2rot\ax = *obj2\rot\ax
      o2rot\ay = *obj2\rot\ay
      o2rot\az = *obj2\rot\az
    EndIf
    
    d = o1dy ; (note: won't work if dy is zero but other movement is not, but should work with the isBullet check above)
    
    o1minSize = *obj1\boxCollider\minSize
    o2minSize = *obj2\boxCollider\minSize
    
    ; shots and player sight travel mainly along their maxSize
    If (*obj1\properties & #property_isBullet) Or (*obj1 = app\player\sight)
      o1minSize = *obj1\boxCollider\maxSize ; = 20 ; [shot size]
    EndIf
    
    minSize = min(o1minSize, o2minSize)
    
    ;stpNorm = 1.0                                     ; default step
;     If d = 0
;       CallDebugger
;       MessageRequester("division by zero", #PB_Compiler_Filename + ", " + #PB_Compiler_Line)
;       End
;     EndIf
    stpNorm = 1.0 ; / d                                  ; default step
;     If *obj1\boxCollider\minSize > 1                ; avoid div 0
;       stpNorm = d / (*obj1\boxCollider\minSize - 1) ; (-1 to ensure some overlaping of interpolation steps)
    If minSize > 0
      stpNorm = d / minSize       
      If stpNorm <> 0
        stpNorm = 1 / stpNorm                       ; normalize to 0..1
      Else
        stpNorm = 1
      EndIf
    EndIf
;     If d = 0
;       stpNorm = 1.0
;     Else
;       If *obj1\boxCollider\minSize = 0
;       Else
;         stpNorm = 1.0 / (d / *obj1\boxCollider\minSize)
;       EndIf
;     EndIf
    
    ;Assert(d > 0)
    
    ; only disabled to debug other things, not inquired yet
    ;Assert(stpNorm > 0)
    
    If stpNorm < 0.1 ; (player sight might be short, causing very small steps)
;       Debug *obj1
;       Debug app\player\sight
;       CallDebugger
      stpNorm = 0.1
    EndIf
;     Debug ""
;     Debug "d:"+d
;     Debug "*obj1\boxCollider\minSize:"+*obj1\boxCollider\minSize
;     Debug "stpNorm:"+stpNorm
    
;     If *obj1 = app\player\sight And *obj2 = app\debObj1
;       ;Debug *obj2\posPrevious\y
;     EndIf
    
    f = 0.0
    Repeat
      
      o1pos\x = *obj1\posPrevious\x + (o1dx * f)
      o1pos\y = *obj1\posPrevious\y + (o1dy * f)
      o1pos\z = *obj1\posPrevious\z + (o1dz * f)
      o1rot\ax = *obj1\rotPrevious\ax + (o1dax * f)
      o1rot\ay = *obj1\rotPrevious\ay + (o1day * f)
      o1rot\az = *obj1\rotPrevious\az + (o1daz * f)
      
      If *obj2\properties & #property_isMovable
        o2pos\x = *obj2\posPrevious\x + (o2dx * f)
        o2pos\y = *obj2\posPrevious\y + (o2dy * f)
        o2pos\z = *obj2\posPrevious\z + (o2dz * f)
        o2rot\ax = *obj2\rotPrevious\ax + (o2dax * f)
        o2rot\ay = *obj2\rotPrevious\ay + (o2day * f)
        o2rot\az = *obj2\rotPrevious\az + (o2daz * f)
      EndIf
      
      If boxCollision(*obj1\boxCollider, o1pos, o1rot\ax, o1rot\ay, o1rot\az, 
                      *obj2\boxCollider, o2pos, o2rot\ax, o2rot\ay, o2rot\az)
;         If *obj1 = app\player\sight And *obj2 = app\debObj1
;           Debug "-----"
;           Debug o1pos\x
;           Debug o1pos\y
;           Debug o1pos\z
;           Debug *obj1\boxCollider
;           Debug *obj2\boxCollider
;           
;           Protected _i
;           Debug "----- x " : For _i=0 To 7 : Debug "  " + StrF(*obj1\boxCollider\p[_i]\x, 0) : Next
;           Debug "----- y " : For _i=0 To 7 : Debug "  " + StrF(*obj1\boxCollider\p[_i]\y, 0) : Next
;           Debug "----- z " : For _i=0 To 7 : Debug "  " + StrF(*obj1\boxCollider\p[_i]\z, 0) : Next
;           Debug "----- x " : For _i=0 To 7 : Debug "  " + StrF(*obj2\boxCollider\p[_i]\x, 0) : Next
;           Debug "----- y " : For _i=0 To 7 : Debug "  " + StrF(*obj2\boxCollider\p[_i]\y, 0) : Next
;           Debug "----- z " : For _i=0 To 7 : Debug "  " + StrF(*obj2\boxCollider\p[_i]\z, 0) : Next
;           
;           ;CallDebugger
;           app\deb = #True
;           boxCollision(*obj1\boxCollider, o1pos, o1rot\ax, o1rot\ay, o1rot\az, 
;                        *obj2\boxCollider, o2pos, o2rot\ax, o2rot\ay, o2rot\az)
;           
;         EndIf
        ProcedureReturn #True
      EndIf
      f + stpNorm
    Until f > 1
    If boxCollision(*obj1\boxCollider, *obj1\pos, *obj1\rot\ax, *obj1\rot\ay, *obj1\rot\az, 
                    *obj2\boxCollider, *obj2\pos, *obj2\rot\ax, *obj2\rot\ay, *obj2\rot\az)
      ProcedureReturn #True
    EndIf
    
  EndIf
  
;   If app\deb
;     If *obj1\posPrevious\y < *obj2\pos\y And *obj2\pos\y < *obj1\pos\y
;       ;CallDebugger
;     EndIf
;   EndIf
  
  ProcedureReturn #False
EndProcedure

Procedure checkCollisions()
;   Shared objects(),  *objectsStart, *objectsEnd
  Define *objFirst.sObject, *objSecond.sObject
  
  Define *sightTarget.sObject
  ; (static to preserve, not for performance)
  Static *sightTargetPrevious.sObject
  Static sightTargetPreviousTimer.q
  Static checkCollision
  
  *sightTarget = #Null
  
  ChangeCurrentElement(app\objects(), app\objectsStart)
  PreviousElement(app\objects())
  While NextElement(app\objects())
    *objFirst = app\objects()
    
    ; only shots as obj 1 or player sight object
    If (*objFirst\properties & #property_isBullet) Or (*objFirst = app\player\sight)
      
      PushListPosition(app\objects())
      
      ChangeCurrentElement(app\objects(), app\objectsStart)
      PreviousElement(app\objects())
      While NextElement(app\objects())
        *objSecond = app\objects()
        
        If *objSecond\targeted
          *objSecond\targeted = #False
        EndIf
        
        If (*objSecond\properties & #property_isBullet)
          ; shots don't collide with other shots
        ElseIf (*objSecond = *objFirst\parentObject)
          ; shots don't collide with their own shooter
        ElseIf (*objSecond = app\player\sight)
          ; player sight only as first object
        Else
          ; pre-check overlapping travelled space
          checkCollision = #False
          If 0;(*objFirst = app\player\sight)
            checkCollision = #True
          Else
            ;If ((*objFirst\travelledSpaceMin\y < (*objSecond\pos\y + *objSecond\boxCollider\minSize)) And (*objFirst\travelledSpaceMax\y > (*objSecond\pos\y - *objSecond\boxCollider\minSize)))
            If (*objFirst\travelledSpaceMin\x <= *objSecond\travelledSpaceMax\x) And (*objFirst\travelledSpaceMax\x >= *objSecond\travelledSpaceMin\x) And 
               (*objFirst\travelledSpaceMin\y <= *objSecond\travelledSpaceMax\y) And (*objFirst\travelledSpaceMax\y >= *objSecond\travelledSpaceMin\y) And 
               (*objFirst\travelledSpaceMin\z <= *objSecond\travelledSpaceMax\z) And (*objFirst\travelledSpaceMax\z >= *objSecond\travelledSpaceMin\z)
              ;If (*objFirst = app\player\sight)
              ;  Debug "sight"+Random(999)
              ;EndIf
              checkCollision = #True
            EndIf
          EndIf
          
          ;checkCollision = #True
          
          If checkCollision
          
          ;syn err
          ; added quick tests for x and z as well (isn't proper regarding collision check)
          If 1;Abs(*objFirst\pos\x - *objSecond\pos\x) < (2 * *objFirst\boxCollider\minSize + 2 * *objSecond\boxCollider\minSize)
          If 1;Abs(*objFirst\pos\z - *objSecond\pos\z) < (2 * *objFirst\boxCollider\minSize + 2 * *objSecond\boxCollider\minSize)
;             If *objFirst = app\player\sight
;               ;Debug "yes"+Random(1000)
;               Debug *objSecond
;             EndIf
            
;             app\deb = #False ; (note, might be set in boxcollinterpol too)
;             If (*objFirst\properties & #property_isBullet) And (*objSecond = app\debObj1)
;               Debug "-----"
;               app\deb = #True
;             EndIf
            If boxCollisionInterpolated(*objFirst, *objSecond)
;               If app\deb
;                 Debug "coll"
;               EndIf
              
              If (*objFirst = app\player\sight)
                If (*objSecond <> app\player\ship)
                  ;*objSecond\targeted = #True
                  *sightTarget = *objSecond
                  
                  ;If     *objSecond = app\debObj1 : Debug "hit 1"
                  ;ElseIf *objSecond = app\debObj2 : Debug "hit 2"
                  ;ElseIf *objSecond = app\debObj3 : Debug "hit 3"
                  ;Else :                            Debug "hit other"
                  ;EndIf
                  
                EndIf
              Else
                If (*objFirst\properties & #property_isBullet)
                  deleteObjectLater(*objFirst)
                EndIf
                *objSecond\colorFaces = $880000ff - Random($55)
                If *objSecond = app\player\ship
                  app\player\energy - 1
                Else
                  *objSecond\health - 40
                  If *objSecond\health <= 0
                    *objSecond\health = 0
                    If Not *objSecond\deleteLater ; (avoid duplicate destruction if double shot hits)
                      destroyObject(*objSecond)
                    EndIf
                    deleteObjectLater(*objSecond)
                  EndIf
                EndIf
              EndIf
;             Else
;               If app\deb
;                 Debug "nocoll"
;               EndIf
            EndIf
          EndIf
          EndIf
          EndIf
        EndIf
        
        If app\objects() = app\objectsEnd
          Break
        EndIf
      Wend
      
      PopListPosition(app\objects())
      
    EndIf
    
    If app\objects() = app\objectsEnd
      Break
    EndIf
  Wend
  
  If *sightTarget
    *sightTargetPrevious = *sightTarget
    sightTargetPreviousTimer = ElapsedMilliseconds()
  ElseIf sightTargetPreviousTimer < (ElapsedMilliseconds() - app\timePlayerSightTargetInvalidate)
    *sightTargetPrevious = #Null
  EndIf
  
  If *sightTargetPrevious
    *sightTargetPrevious\targeted = #True
  EndIf
  
  Define maxSightSize.f
  ; (cam view length) - ((player pos rel-to-cam) + (sight pos rel-to-player))
  maxSightSize = (app\camFar - (app\player\sight\pos\y - app\cam\y)) - 1.0
  
  If *sightTarget
    ;app\player\sightYSize = app\player\sightYSize * 0.5
    ;Debug "reset"
    app\player\sightYSize = 0.1
  Else
    app\player\sightYSize = 10 + app\player\sightYSize * 1.18  ; (real)
    ;app\player\sightYSize + 0.1                                 ; (test)
  EndIf
  If app\player\sightYSize > maxSightSize
    ;Debug "clip"
    app\player\sightYSize = maxSightSize
  ElseIf app\player\sightYSize <= 0
    app\player\sightYSize = 0.1 ; (old)
  EndIf
  ;app\player\sightYSize = 2000
  setBoxYSize(app\player\sight, app\player\sightYSize)
  ;updateTravelledSpace(app\player\sight)
  ;Debug app\player\sight\boxCollider\minSize
  
EndProcedure

Procedure sortObjects()
;   Shared objects()
  ; note that it only sorts the objects in the list for order of rendering, their position in space does not change.
  SortStructuredList(app\objects(), #PB_Sort_Ascending, OffsetOf(sObject\pos) + OffsetOf(sVec3\z), #PB_Float)
  SortStructuredList(app\objects(), #PB_Sort_Descending, OffsetOf(sObject\pos) + OffsetOf(sVec3\y), #PB_Float)
EndProcedure

Procedure updateObjectsStart(List objects.sObject(), *objectsStartPointer.Integer, camY, camFar)
  Protected *objectsStart.sObject = *objectsStartPointer\i
  ;Shared camFar
  ChangeCurrentElement(app\objects(), *objectsStartPointer\i)
  If *objectsStart\pos\y <= (camY + camFar)              ; if current start is within cam depth
    While PreviousElement(app\objects())                     ; search backward in list (which means backward in rendering order wich is forward into +y)
      If app\objects()\pos\y <= (camY + camFar)              ; if object is within cam depth
        *objectsStartPointer\i = app\objects()               ; use object as start
      Else
        Break                                            ; stop if object is beyond cam depth
      EndIf
    Wend
  ElseIf *objectsStart\pos\y > (camY + camFar)           ; if current start is beyond cam depth
    While NextElement(app\objects())                         ; search forward in list (which means forward in rendering order wich is backward into -y)
      If app\objects()\pos\y <= (camY + camFar)              ; if object is within cam depth
        *objectsStartPointer\i = app\objects()               ; use object as start
        Break                                            ; and then stop
      EndIf
    Wend
  EndIf
EndProcedure

Procedure updateObjectsEnd(List objects.sObject(), *objectsEndPointer.Integer, camY)
  Protected *objectsEnd.sObject = *objectsEndPointer\i
  ChangeCurrentElement(app\objects(), *objectsEndPointer\i)
  If *objectsEnd\pos\y >= (camY)                         ; if current end is within cam depth
    While NextElement(app\objects())                         ; search forward in list (which means forward in rendering order wich is backward into -y)
      If app\objects()\pos\y >= (camY)                       ; if object is within cam depth
        *objectsEndPointer\i = app\objects()                 ; use object as end
      Else
        Break                                            ; stop if object is behind cam depth
      EndIf
    Wend
  ElseIf *objectsEnd\pos\y < (camY)                      ; if current end is behind cam depth
    While PreviousElement(app\objects())                     ; search backward in list (which means backward in rendering order wich is forward into +y)
      If app\objects()\pos\y <= (camY)                       ; if object is within cam depth
        *objectsEndPointer\i = app\objects()                 ; use object as end
        Break                                            ; and then stop
      EndIf
    Wend
  EndIf
EndProcedure

;
; IDE Options = PureBasic 5.70 LTS beta 2 (Linux - x64)
; CursorPosition = 881
; FirstLine = 681
; Folding = Dtz55
; Markers = 23,46,56,64,192,328,363,808,880,996,1050,1127
; EnableXP