﻿
XIncludeFile "rotation.h.pbi"

XIncludeFile "vec.pbi"


Procedure.f normalizeAngle(a.f)
  ; normalizes to range -PI..0..PI (-180..0..180)
  If a <= (-#PI)
    a + (2.0 * #PI)
  ElseIf a > #PI
    a - (2.0 * #PI)
  EndIf
  ProcedureReturn a
EndProcedure

Procedure rotateGlobally(dx.f, dy.f, dz.f,  ax.f, ay.f, az.f,  *dxOut.Float, *dyOut.Float, *dzOut.Float)
  ;Shared cam
  Define lx.f
  Define ly.f
  Define lz.f
  
  ; each rotation is applied to absolute/global axis, not to rotated/local axis
  
  ; todo: document rotation
  
  ; rotate around x axis (up/down, pitch)
  lx = Sqr(dz * dz + dy * dy)
  ax = ATan2( dz, dy) + ax
  *dzOut\f = lx * Cos(ax)
  *dyOut\f = lx * Sin(ax)
  dz = *dzOut\f
  dy = *dyOut\f
  
  ; rotate around y axis (left/right, roll)
  ly = Sqr(dx * dx + dz * dz)
  ay = ATan2( dx, dz) + ay
  *dxOut\f = ly * Cos(ay)
  *dzOut\f = ly * Sin(ay)
  dx = *dxOut\f
  dz = *dzOut\f
  
  ; rotate around z axis (turn, yaw)
  lz = Sqr(dy * dy + dx * dx)
  az = ATan2( dy, dx) + az
  *dyOut\f = lz * Cos(az)
  *dxOut\f = lz * Sin(az)
  ;dx = *dxOut\f
  ;dy = *dyOut\f
  
EndProcedure

Procedure rotateAroundAxis(*p.sVec3, theta.f, *axis.sVec3, *pOut.sVec3)
  ; from:
  ; http://paulbourke.net/geometry/rotate/source.c
  ; http://paulbourke.net/geometry/rotate/
  
  Static.f costheta, sintheta
  costheta = Cos(-theta) ; (anticlockwise)
  sintheta = Sin(-theta)
  
  vecNormalizeMagnitude( *axis)
  
  *pOut\x = 0
  *pOut\y = 0
  *pOut\z = 0
  
  *pOut\x + (costheta + (1 - costheta) * *axis\x * *axis\x) * *p\x;
  *pOut\x + ((1 - costheta) * *axis\x * *axis\y - *axis\z * sintheta) * *p\y;
  *pOut\x + ((1 - costheta) * *axis\x * *axis\z + *axis\y * sintheta) * *p\z;
  
  *pOut\y + ((1 - costheta) * *axis\x * *axis\y + *axis\z * sintheta) * *p\x;
  *pOut\y + (costheta + (1 - costheta) * *axis\y * *axis\y) * *p\y;
  *pOut\y + ((1 - costheta) * *axis\y * *axis\z - *axis\x * sintheta) * *p\z;
  
  *pOut\z + ((1 - costheta) * *axis\x * *axis\z - *axis\y * sintheta) * *p\x;
  *pOut\z + ((1 - costheta) * *axis\y * *axis\z + *axis\x * sintheta) * *p\y;
  *pOut\z + (costheta + (1 - costheta) * *axis\z * *axis\z) * *p\z          ;
  
  
;   ; test rotateAroundAxis(), copy outside proc
;   Define.sVec3 v, p, p2
;   vecSet( @ v, 10, 10, 10)
;   vecSet( @ p, 10, 0, 0)
;   rotateAroundAxis( @ p, Radian(45), @ v, @ p2)
;   Debug "p2: " + p2\x + ", " + p2\y + ", " + p2\z
;   End
EndProcedure

Procedure rotate(dx.f, dy.f, dz.f,  ax.f, ay.f, az.f,  *dxOut.Float, *dyOut.Float, *dzOut.Float)
  ;Define.sVec3 p, axisX, axisY, axisZ, pOut
  Static.sVec3 p, axisX, axisY, axisZ, pOut
  vecSet( @ p,  dx, dy, dz)
  vecSet( @ axisX, 1, 0, 0)
  vecSet( @ axisY, 0, 1, 0)
  vecSet( @ axisZ, 0, 0, 1)
  
  ; on each axis rotate p as well as the other 2 axes
  
  
;   ; rotation order: ax, ay, az
;     
;   rotateAroundAxis( @ p,     ax, @ axisX, @ pOut)   :  vecSetByVec( @ p,     @ pOut)
;   rotateAroundAxis( @ axisY, ax, @ axisX, @ pOut)   :  vecSetByVec( @ axisY, @ pOut)
;   rotateAroundAxis( @ axisZ, ax, @ axisX, @ pOut)   :  vecSetByVec( @ axisZ, @ pOut)
;   
;   rotateAroundAxis( @ p,     ay, @ axisY, @ pOut)   :  vecSetByVec( @ p,     @ pOut)
;   rotateAroundAxis( @ axisX, ay, @ axisY, @ pOut)   :  vecSetByVec( @ axisX, @ pOut)
;   rotateAroundAxis( @ axisZ, ay, @ axisY, @ pOut)   :  vecSetByVec( @ axisZ, @ pOut)
;   
;   rotateAroundAxis( @ p,     az, @ axisZ, @ pOut)   :  vecSetByVec( @ p,     @ pOut)
;   rotateAroundAxis( @ axisX, az, @ axisZ, @ pOut)   :  vecSetByVec( @ axisX, @ pOut)
;   rotateAroundAxis( @ axisY, az, @ axisZ, @ pOut)   :  vecSetByVec( @ axisY, @ pOut)
  
  
  ; rotation order: az, ax, ay
  
  rotateAroundAxis( @ p,     az, @ axisZ, @ pOut)   :  vecSetByVec( @ p,     @ pOut)
  rotateAroundAxis( @ axisX, az, @ axisZ, @ pOut)   :  vecSetByVec( @ axisX, @ pOut)
  rotateAroundAxis( @ axisY, az, @ axisZ, @ pOut)   :  vecSetByVec( @ axisY, @ pOut)
  
  rotateAroundAxis( @ p,     ax, @ axisX, @ pOut)   :  vecSetByVec( @ p,     @ pOut)
  rotateAroundAxis( @ axisY, ax, @ axisX, @ pOut)   :  vecSetByVec( @ axisY, @ pOut)
  rotateAroundAxis( @ axisZ, ax, @ axisX, @ pOut)   :  vecSetByVec( @ axisZ, @ pOut)
  
  rotateAroundAxis( @ p,     ay, @ axisY, @ pOut)   :  vecSetByVec( @ p,     @ pOut)
  rotateAroundAxis( @ axisX, ay, @ axisY, @ pOut)   :  vecSetByVec( @ axisX, @ pOut)
  rotateAroundAxis( @ axisZ, ay, @ axisY, @ pOut)   :  vecSetByVec( @ axisZ, @ pOut)
  
  
  *dxOut\f = p\x
  *dyOut\f = p\y
  *dzOut\f = p\z
EndProcedure
; IDE Options = PureBasic 5.70 LTS beta 2 (Linux - x64)
; Folding = -
; EnableXP