﻿
XIncludeFile "vec.h.pbi"

Procedure vecSet(*v.sVec3, x.f, y.f, z.f)
  *v\x = x
  *v\y = y
  *v\z = z
EndProcedure

Procedure vecSetByVec(*v1.sVec3, *v2.sVec3)
  *v1\x = *v2\x
  *v1\y = *v2\y
  *v1\z = *v2\z
EndProcedure

Procedure vecAdd(*v1.sVec3, *v2.sVec3)
  *v1\x + *v2\x
  *v1\y + *v2\y
  *v1\z + *v2\z
EndProcedure

Procedure vecMinus(*a.sVec3, *b.sVec3, *out.sVec3)
  *out\x = *a\x - *b\x
  *out\y = *a\y - *b\y
  *out\z = *a\z - *b\z
EndProcedure

Procedure vecCrossProduct(*a.sVec3, *b.sVec3, *out.sVec3)
  *out\x = (*a\y * *b\z) - (*a\z * *b\y)
  *out\y = (*a\z * *b\x) - (*a\x * *b\z)
  *out\z = (*a\x * *b\y) - (*a\y * *b\x)
EndProcedure

Procedure.f vecDotProduct(*a.sVec3, *b.sVec3)
  ProcedureReturn *a\x * *b\x + *a\y * *b\y + *a\z * *b\z
EndProcedure

Procedure vecNormalizeMagnitude(*v.sVec3)
  Static.f f
  f = Sqr(*v\x * *v\x + *v\y * *v\y + *v\z * *v\z)
  ; avoid division-by-zero if v is a zero-vector {0,0,0} (can happen for normals of parallel edges)
  If f
    f = 1 / f
    *v\x * f
    *v\y * f
    *v\z * f
  EndIf
EndProcedure
; IDE Options = PureBasic 5.70 LTS beta 2 (Linux - x64)
; CursorPosition = 21
; FirstLine = 4
; Folding = --
; EnableXP